/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.registry;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.helper.Helper;
import ovh.corail.woodcutter.item.WoodcutterItem;

public class ModBlocks {
    public static final Set<Block> WOODCUTTERS = new HashSet<Block>();
    public static final Set<Item> WOODCUTTER_ITEMS = new HashSet<Item>();
    private static final Random RANDOM = new Random();
    private static ItemStack RANDOM_STACK = ItemStack.f_41583_;

    static void onRegisterBlocks(RegisterEvent event) {
        ModBlocks.registerWoodcutter(event, "", "acacia", "bamboo", "bamboo_mosaic", "birch", "cherry", "crimson", "dark_oak", "jungle", "spruce", "mangrove", "oak", "warped");
        if (SupportMods.BIOMESOPLENTY.isLoaded()) {
            ModBlocks.registerWoodcutter(event, "bop", "dead", "fir", "hellbark", "jacaranda", "magic", "mahogany", "palm", "redwood", "umbran", "willow");
        }
    }

    static void onRegisterBlockItems(RegisterEvent event) {
        WOODCUTTERS.forEach(woodcutterBlock -> {
            WoodcutterItem woodcutter = new WoodcutterItem((Block)woodcutterBlock);
            WOODCUTTER_ITEMS.add((Item)woodcutter);
            event.register(ForgeRegistries.Keys.ITEMS, Helper.getRegistryRL(woodcutterBlock), () -> ModBlocks.lambda$onRegisterBlockItems$0((Item)woodcutter));
        });
    }

    private static void registerWoodcutter(RegisterEvent event, String folder, String ... names) {
        Function<String, String> funcName = folder.isEmpty() ? name -> name + "_woodcutter" : name -> folder + "_" + name + "_woodcutter";
        for (String name2 : names) {
            WoodcutterBlock woodcutter = new WoodcutterBlock();
            WOODCUTTERS.add((Block)woodcutter);
            event.register(ForgeRegistries.Keys.BLOCKS, new ResourceLocation("corail_woodcutter", funcName.apply(name2)), () -> ModBlocks.lambda$registerWoodcutter$4((Block)woodcutter));
        }
    }

    public static ItemStack createRandomStack() {
        if (RANDOM_STACK.m_41619_()) {
            RANDOM_STACK = new ItemStack((ItemLike)WOODCUTTERS.stream().skip(RANDOM.nextInt(WOODCUTTERS.size())).findFirst().orElse(Blocks.f_50679_));
        }
        return RANDOM_STACK;
    }

    private static /* synthetic */ Block lambda$registerWoodcutter$4(Block woodcutter) {
        return woodcutter;
    }

    private static /* synthetic */ Item lambda$onRegisterBlockItems$0(Item woodcutter) {
        return woodcutter;
    }
}

