/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.heart;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.heart.Heart;
import terrails.colorfulhearts.heart.HeartPiece;

public class HeartTests {
    public static void runTests() {
        try {
            HeartTests.checkStandardHearts();
            CColorfulHearts.LOGGER.info("All tests passed for standard heart renderer.");
        }
        catch (RuntimeException e) {
            if (e.getMessage() == null) {
                CColorfulHearts.LOGGER.error("Tests failed for standard heart renderer.");
                e.printStackTrace();
            }
            CColorfulHearts.LOGGER.error("Tests failed for standard heart renderer: {}", (Object)e.getMessage());
        }
        try {
            HeartTests.checkSameRowHearts();
            CColorfulHearts.LOGGER.info("All tests passed for same row heart renderer.");
        }
        catch (RuntimeException e) {
            if (e.getMessage() == null) {
                CColorfulHearts.LOGGER.error("Tests failed for same row heart renderer.");
                e.printStackTrace();
            }
            CColorfulHearts.LOGGER.error("Tests failed for same row heart renderer: {}", (Object)e.getMessage());
        }
    }

    private static void checkStandardHearts() {
        List<HeartPiece> healthColors = List.of(HeartPiece.custom("#123456", false), HeartPiece.VANILLA_HEALTH, HeartPiece.custom("#321456", false));
        List<HeartPiece> absorptionColors = List.of(HeartPiece.custom("#654321", true), HeartPiece.VANILLA_ABSORPTION, HeartPiece.custom("#456123", true));
        HeartTests.checkCommonHearts(false);
        Object[] testResult = new Heart[16];
        Arrays.fill(testResult, 0, 8, Heart.full(healthColors.get(0)));
        testResult[8] = Heart.half(healthColors.get(0), true);
        testResult[9] = Heart.CONTAINER_FULL;
        Arrays.fill(testResult, 10, 15, Heart.full(absorptionColors.get(0)));
        testResult[15] = Heart.half(absorptionColors.get(0), false);
        HeartTests.testHearts((Heart[])testResult, 11, 17, 123, healthColors, absorptionColors, false);
        testResult = new Heart[15];
        Arrays.fill(testResult, 0, 8, Heart.full(healthColors.get(0)));
        testResult[8] = Heart.half(healthColors.get(0), false);
        Arrays.fill(testResult, 9, 14, Heart.full(absorptionColors.get(0)));
        testResult[14] = Heart.half(absorptionColors.get(0), false);
        HeartTests.testHearts((Heart[])testResult, 11, 17, 17, healthColors, absorptionColors, false);
        testResult = new Heart[15];
        Arrays.fill(testResult, 0, 8, Heart.full(healthColors.get(0)));
        testResult[8] = Heart.half(healthColors.get(0), false);
        Arrays.fill(testResult, 9, 14, Heart.full(absorptionColors.get(0)));
        testResult[14] = Heart.half(absorptionColors.get(0), false);
        HeartTests.testHearts((Heart[])testResult, 11, 17, 17, healthColors, absorptionColors, false);
        testResult = new Heart[20];
        Arrays.fill(testResult, 0, 8, Heart.full(healthColors.get(0)));
        testResult[8] = Heart.half(healthColors.get(0), true);
        testResult[9] = Heart.CONTAINER_FULL;
        Arrays.fill(testResult, 10, 15, Heart.full(absorptionColors.get(1)));
        testResult[15] = Heart.full(absorptionColors.get(1), absorptionColors.get(0));
        Arrays.fill(testResult, 16, 20, Heart.full(absorptionColors.get(0)));
        HeartTests.testHearts((Heart[])testResult, 31, 17, 123, healthColors, absorptionColors, false);
        testResult = new Heart[20];
        Arrays.fill(testResult, 0, 8, Heart.full(healthColors.get(0)));
        testResult[8] = Heart.half(healthColors.get(0), false);
        Arrays.fill(testResult, 9, 13, Heart.full(absorptionColors.get(1)));
        testResult[13] = Heart.full(absorptionColors.get(1), absorptionColors.get(0));
        Arrays.fill(testResult, 14, 20, Heart.full(absorptionColors.get(0)));
        HeartTests.testHearts((Heart[])testResult, 31, 17, 17, healthColors, absorptionColors, false);
    }

    private static void checkSameRowHearts() {
        List<HeartPiece> healthColors = List.of(HeartPiece.custom("#123456", false), HeartPiece.VANILLA_HEALTH, HeartPiece.custom("#321456", false));
        List<HeartPiece> absorptionColors = List.of(HeartPiece.custom("#654321", true), HeartPiece.VANILLA_ABSORPTION, HeartPiece.custom("#456123", true));
        HeartTests.checkCommonHearts(true);
        Object[] testResult = new Heart[10];
        Arrays.fill(testResult, 0, 4, Heart.full(absorptionColors.get(0)));
        Arrays.fill(testResult, 4, 9, Heart.full(healthColors.get(0)));
        testResult[8] = Heart.full(healthColors.get(0), absorptionColors.get(0));
        testResult[9] = Heart.full(absorptionColors.get(0));
        HeartTests.testHearts((Heart[])testResult, 11, 17, 123, healthColors, absorptionColors, true);
        testResult = new Heart[10];
        Arrays.fill(testResult, 0, 5, Heart.full(absorptionColors.get(1)));
        testResult[5] = Heart.full(absorptionColors.get(1), absorptionColors.get(0));
        Arrays.fill(testResult, 6, 10, Heart.full(absorptionColors.get(0)));
        HeartTests.testHearts((Heart[])testResult, 31, 17, 20, healthColors, absorptionColors, true);
        testResult = new Heart[10];
        Arrays.fill(testResult, 0, 3, Heart.full(healthColors.get(1)));
        testResult[3] = Heart.full(healthColors.get(1), absorptionColors.get(0));
        Arrays.fill(testResult, 4, 6, Heart.full(absorptionColors.get(0)));
        Arrays.fill(testResult, 6, 10, Heart.full(healthColors.get(0)));
        HeartTests.testHearts((Heart[])testResult, 5, 27, 20, healthColors, absorptionColors, true);
    }

    private static void checkCommonHearts(boolean absorptionSameRow) {
        List<HeartPiece> healthColors = List.of(HeartPiece.custom("#123456", false), HeartPiece.VANILLA_HEALTH, HeartPiece.custom("#321456", false));
        List<HeartPiece> absorptionColors = List.of(HeartPiece.custom("#654321", true), HeartPiece.VANILLA_ABSORPTION, HeartPiece.custom("#456123", true));
        Object[] testResult = new Heart[10];
        Arrays.fill(testResult, 0, 8, Heart.full(healthColors.get(0)));
        testResult[8] = Heart.half(healthColors.get(0), true);
        testResult[9] = Heart.CONTAINER_FULL;
        HeartTests.testHearts((Heart[])testResult, 0, 17, 123, healthColors, absorptionColors, absorptionSameRow);
        testResult = new Heart[10];
        Arrays.fill(testResult, Heart.full(healthColors.get(0)));
        HeartTests.testHearts((Heart[])testResult, 0, 20, 123, healthColors, absorptionColors, absorptionSameRow);
        testResult = new Heart[10];
        Arrays.fill(testResult, 0, 8, Heart.full(healthColors.get(1)));
        testResult[8] = Heart.full(healthColors.get(1), healthColors.get(0));
        testResult[9] = Heart.full(healthColors.get(0));
        HeartTests.testHearts((Heart[])testResult, 0, 37, 123, healthColors, absorptionColors, absorptionSameRow);
        testResult = new Heart[10];
        Arrays.fill(testResult, Heart.full(healthColors.get(1)));
        HeartTests.testHearts((Heart[])testResult, 0, 40, 123, healthColors, absorptionColors, absorptionSameRow);
    }

    private static void testHearts(Heart[] testResult, int absorption, int health, int maxHealth, List<HeartPiece> healthColors, List<HeartPiece> absorptionColors, boolean absorptionSameRow) {
        Object[] hearts = Heart.calculateHearts(absorption, health, maxHealth, healthColors, absorptionColors, absorptionSameRow);
        if (!Arrays.equals(testResult, hearts)) {
            String errMsg = "Failed to properly calculate a heart bar with { maxHealth: " + maxHealth + ", health: " + health + ", absorption: " + absorption + ", samRow: " + absorptionSameRow + " }";
            errMsg = errMsg + "\nExpected: " + testResult.length + " [\n" + Arrays.stream(testResult).map(Heart::toString).collect(Collectors.joining("\n")) + "\n]";
            errMsg = errMsg + "\nGotten: " + hearts.length + " [\n" + Arrays.stream(hearts).map(Heart::toString).collect(Collectors.joining("\n")) + "\n]";
            throw new RuntimeException(errMsg);
        }
    }
}

