/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config.screen.widgets;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import terrails.colorfulhearts.heart.HeartPiece;
import terrails.colorfulhearts.heart.HeartType;

public class HeartColorEditBox
extends EditBox {
    private static final Pattern HEX_FORMAT = Pattern.compile("^#[0-9a-fA-F]{0,6}$");
    private static final Pattern HEX_MATCH = Pattern.compile("^#[0-9a-fA-F]{6}$");
    private boolean validHex;
    private final boolean health;
    private final HeartType type;

    public HeartColorEditBox(Font font, int x, int y, int width, int height, Component component, HeartType type, boolean health) {
        this(font, x, y, width, height, null, component, type, health);
    }

    public HeartColorEditBox(Font font, int x, int y, int width, int height, @Nullable EditBox editBox, Component component, HeartType type, boolean health) {
        super(font, x, y, width, height, editBox, component);
        this.type = type;
        this.health = health;
        this.m_94151_(str -> {});
        this.m_94153_(str -> HEX_FORMAT.matcher((CharSequence)str).matches());
        this.m_94199_(7);
        if (editBox != null) {
            this.m_94144_(editBox.m_94155_());
        }
    }

    public boolean isValidHex() {
        return this.validHex;
    }

    public HeartPiece getHeartPiece() {
        return HeartPiece.custom(this.m_94155_(), !this.health);
    }

    public void m_94151_(@NotNull Consumer<String> responder) {
        super.m_94151_(str -> {
            this.validHex = HEX_MATCH.matcher((CharSequence)str).matches();
            responder.accept((String)str);
        });
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.m_94213_()) {
            return;
        }
        if (!this.isValidHex()) {
            boolean isBordered;
            boolean bl = isBordered = this.m_94210_() < this.f_93618_;
            if (isBordered) {
                int borderColor = this.m_93696_() ? -2743526 : -10942713;
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_(), borderColor);
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() + this.f_93619_, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, borderColor);
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_(), this.m_252754_(), this.m_252907_() + this.f_93619_, borderColor);
                guiGraphics.m_280509_(this.m_252754_() + this.f_93618_, this.m_252907_(), this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_, borderColor);
            }
        } else {
            HeartPiece heart = this.getHeartPiece();
            heart.draw(guiGraphics.m_280168_(), this.m_252754_() + this.f_93618_ - 11, this.m_252907_() + this.f_93619_ / 2 - 4, false, false, this.type);
        }
    }
}

