/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.common.inventory.wrapper;

import cofh.lib.common.inventory.SimpleItemInv;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InvWrapperCoFH
implements Container {
    protected SimpleItemInv inventory;
    protected int stackLimit;

    public InvWrapperCoFH(SimpleItemInv inventory) {
        this(inventory, 64);
    }

    public InvWrapperCoFH(SimpleItemInv inventory, int stackLimit) {
        this.inventory = inventory;
        this.stackLimit = MathHelper.clamp(stackLimit, 1, Integer.MAX_VALUE);
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }

    public void onInventoryChange(int slot) {
        this.inventory.onInventoryChange(slot);
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        return this.inventory.isEmpty();
    }

    public ItemStack m_8020_(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack inSlot = this.inventory.get(index);
        if (inSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (inSlot.m_41613_() <= count) {
            count = inSlot.m_41613_();
        }
        ItemStack stack = inSlot.m_41620_(count);
        if (inSlot.m_41613_() <= 0) {
            this.inventory.set(index, ItemStack.f_41583_);
            this.inventory.onInventoryChange(index);
        }
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.inventory.get(index);
        this.inventory.set(index, ItemStack.f_41583_);
        this.inventory.onInventoryChange(index);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (this.inventory.get(index).equals(stack)) {
            return;
        }
        this.inventory.set(index, stack);
        this.inventory.onInventoryChange(index);
    }

    public int m_6893_() {
        return this.stackLimit;
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.inventory.isItemValid(index, stack);
    }

    public void m_6211_() {
        this.inventory.clear();
    }
}

