/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.CylindricalParticle;
import cofh.core.client.particle.options.CylindricalParticleOptions;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.SplittableRandom;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Quaternionf;
import org.joml.Vector4f;

public class WindSpiralParticle
extends CylindricalParticle {
    private WindSpiralParticle(CylindricalParticleOptions data, ClientLevel level, double x, double y, double z, double xDir, double yDir, double zDir) {
        super(data, level, x, y, z, xDir, yDir, zDir);
        this.f_107204_ = this.f_107231_ = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLightIn, float time, float pTicks) {
        SplittableRandom rand = new SplittableRandom(this.seed);
        if (!this.rotation.equals((Object)new Quaternionf())) {
            stack.m_252781_(this.rotation);
        }
        float progress = time / this.duration;
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        float easeSin = MathHelper.sin(progress * (float)Math.PI);
        float easePlat = MathHelper.easePlateau(progress);
        float offset = (float)rand.nextDouble(0.0, 0.8f);
        float expand = (progress + offset) * (float)rand.nextDouble(0.3f, 0.5);
        float yScale = offset * (float)rand.nextDouble(0.015f, 0.03f);
        float y = expand * (float)rand.nextDouble(1.0, 1.5) - 0.6f;
        float rot = this.f_107231_ + progress * (float)rand.nextDouble(6.0, 9.0);
        int length = (int)(3.0f + easePlat * (float)rand.nextInt(16, 24));
        Vector4f[] poss = new Vector4f[length];
        int half = length / 2;
        for (int i = 0; i < length; ++i) {
            float angle = (float)(i - half) * 0.1309f + rot;
            float r = this.size * (1.0f + (float)i * 0.02f) * expand;
            poss[i] = new Vector4f(r * MathHelper.cos(angle), (float)i * yScale + this.height * y, r * MathHelper.sin(angle), 1.0f);
        }
        VFXHelper.renderStreamLine(stack, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT), packedLightIn, poss, this.c0, VFXHelper.getWidthFunc((easeSin * 0.08f + 0.01f) * (float)rand.nextDouble(0.3f, 1.0)));
    }

    @Nonnull
    public static ParticleProvider<CylindricalParticleOptions> factory(SpriteSet spriteSet) {
        return WindSpiralParticle::new;
    }
}

