/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.recipe;

import com.google.gson.JsonObject;
import earth.terrarium.chipped.common.util.ModUtils;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

@MethodsReturnNonnullByDefault
public record ChippedRecipe(Serializer serializer, ResourceLocation id, String group, List<? extends HolderSet<Item>> tags, Block icon) implements Recipe<Container>
{
    public boolean m_5818_(Container container, Level level) {
        ItemStack stack = container.m_8020_(0);
        return !stack.m_41619_() && this.tags.stream().anyMatch(tag -> stack.m_220167_(arg_0 -> ((HolderSet)tag).m_203333_(arg_0)));
    }

    public Stream<ItemStack> getResults(Container container) {
        ItemStack current = container.m_8020_(0);
        if (!current.m_41619_()) {
            Item item = current.m_41720_();
            return this.tags.stream().filter(set -> current.m_220167_(arg_0 -> ((HolderSet)set).m_203333_(arg_0))).flatMap(ModUtils::streamHolderSet).filter(value -> value != item).map(ItemStack::new);
        }
        return Stream.empty();
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int j) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)this.icon);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public RecipeType<ChippedRecipe> m_6671_() {
        return this.serializer.type.get();
    }

    public record Serializer(Supplier<RecipeType<ChippedRecipe>> type, Supplier<Block> icon) implements RecipeSerializer<ChippedRecipe>
    {
        public ChippedRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            List<HolderSet.Named> tags = StreamSupport.stream(GsonHelper.m_13933_((JsonObject)json, (String)"tags").spliterator(), false).map(ModUtils::expectResourcelocation).map(tag -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag)).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_203561_(arg_0)).toList();
            return new ChippedRecipe(this, id, group, tags, this.icon.get());
        }

        public ChippedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            List holders = buffer.m_236845_(holderBuf -> HolderSet.m_205803_(Item::m_204114_, (List)buffer.m_236845_(ModUtils::readItem)));
            return new ChippedRecipe(this, recipeId, group, holders, this.icon.get());
        }

        public void toNetwork(FriendlyByteBuf buffer, ChippedRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_236828_(recipe.tags, (buf, tag) -> buf.m_236828_(ModUtils.fromHolderSet(tag), ModUtils::writeItem));
        }
    }
}

