/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class KeyEventServerMessage
extends ComputerServerMessage {
    public static final int TYPE_DOWN = 0;
    public static final int TYPE_REPEAT = 1;
    public static final int TYPE_UP = 2;
    private final int type;
    private final int key;

    public KeyEventServerMessage(AbstractContainerMenu menu, int type, int key) {
        super(menu);
        this.type = type;
        this.key = key;
    }

    public KeyEventServerMessage(FriendlyByteBuf buf) {
        super(buf);
        this.type = buf.readByte();
        this.key = buf.m_130242_();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.writeByte(this.type);
        buf.m_130130_(this.key);
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        ServerInputHandler input = container.getInput();
        if (this.type == 2) {
            input.keyUp(this.key);
        } else {
            input.keyDown(this.key, this.type == 1);
        }
    }

    @Override
    public MessageType<KeyEventServerMessage> type() {
        return NetworkMessages.KEY_EVENT;
    }
}

