/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import net.minecraft.network.FriendlyByteBuf;

public class PocketComputerDataMessage
implements NetworkMessage<ClientNetworkContext> {
    private final int instanceId;
    private final ComputerState state;
    private final int lightState;
    private final TerminalState terminal;

    public PocketComputerDataMessage(PocketServerComputer computer, boolean sendTerminal) {
        this.instanceId = computer.getInstanceID();
        this.state = computer.getState();
        this.lightState = computer.getLight();
        this.terminal = sendTerminal ? computer.getTerminalState() : new TerminalState((NetworkedTerminal)null);
    }

    public PocketComputerDataMessage(FriendlyByteBuf buf) {
        this.instanceId = buf.m_130242_();
        this.state = (ComputerState)buf.m_130066_(ComputerState.class);
        this.lightState = buf.m_130242_();
        this.terminal = new TerminalState(buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.instanceId);
        buf.m_130068_((Enum)this.state);
        buf.m_130130_(this.lightState);
        this.terminal.write(buf);
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handlePocketComputerData(this.instanceId, this.state, this.lightState, this.terminal);
    }

    @Override
    public MessageType<PocketComputerDataMessage> type() {
        return NetworkMessages.POCKET_COMPUTER_DATA;
    }
}

