/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl.network.wired;

import dan200.computercraft.api.network.wired.WiredNetworkChange;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.impl.network.wired.WiredNodeImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class WiredNetworkChangeImpl
implements WiredNetworkChange {
    private static final WiredNetworkChangeImpl EMPTY = new WiredNetworkChangeImpl(Map.of(), Map.of());
    private final Map<String, IPeripheral> removed;
    private final Map<String, IPeripheral> added;

    private WiredNetworkChangeImpl(Map<String, IPeripheral> removed, Map<String, IPeripheral> added) {
        this.removed = removed;
        this.added = added;
    }

    static WiredNetworkChangeImpl changed(Map<String, IPeripheral> removed, Map<String, IPeripheral> added) {
        return new WiredNetworkChangeImpl(Collections.unmodifiableMap(removed), Collections.unmodifiableMap(added));
    }

    static WiredNetworkChangeImpl added(Map<String, IPeripheral> added) {
        return added.isEmpty() ? EMPTY : new WiredNetworkChangeImpl(Map.of(), Collections.unmodifiableMap(added));
    }

    static WiredNetworkChangeImpl removed(Map<String, IPeripheral> removed) {
        return removed.isEmpty() ? EMPTY : new WiredNetworkChangeImpl(Collections.unmodifiableMap(removed), Map.of());
    }

    static WiredNetworkChangeImpl changeOf(Map<String, IPeripheral> oldPeripherals, Map<String, IPeripheral> newPeripherals) {
        if (oldPeripherals.isEmpty() && newPeripherals.isEmpty()) {
            return EMPTY;
        }
        if (oldPeripherals.isEmpty()) {
            return new WiredNetworkChangeImpl(Map.of(), newPeripherals);
        }
        if (newPeripherals.isEmpty()) {
            return new WiredNetworkChangeImpl(oldPeripherals, Map.of());
        }
        HashMap<String, IPeripheral> added = new HashMap<String, IPeripheral>(newPeripherals);
        HashMap<String, IPeripheral> removed = new HashMap<String, IPeripheral>();
        for (Map.Entry<String, IPeripheral> entry : oldPeripherals.entrySet()) {
            String oldKey = entry.getKey();
            IPeripheral oldValue = entry.getValue();
            if (newPeripherals.containsKey(oldKey)) {
                IPeripheral rightValue = (IPeripheral)added.get(oldKey);
                if (oldValue.equals(rightValue)) {
                    added.remove(oldKey);
                    continue;
                }
                removed.put(oldKey, oldValue);
                continue;
            }
            removed.put(oldKey, oldValue);
        }
        return WiredNetworkChangeImpl.changed(removed, added);
    }

    @Override
    public Map<String, IPeripheral> peripheralsAdded() {
        return this.added;
    }

    @Override
    public Map<String, IPeripheral> peripheralsRemoved() {
        return this.removed;
    }

    public boolean isEmpty() {
        return this.added.isEmpty() && this.removed.isEmpty();
    }

    void broadcast(Iterable<WiredNodeImpl> nodes) {
        if (!this.isEmpty()) {
            for (WiredNodeImpl node : nodes) {
                node.element.networkChanged(this);
            }
        }
    }

    void broadcast(WiredNodeImpl node) {
        if (!this.isEmpty()) {
            node.element.networkChanged(this);
        }
    }
}

