/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.NotAttachedException;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.apis.ComputerAccess;
import dan200.computercraft.core.apis.FastLuaException;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.core.metrics.OperationTimer;
import dan200.computercraft.core.util.LuaUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class PeripheralAPI
implements ILuaAPI,
IAPIEnvironment.IPeripheralChangeListener {
    private final IAPIEnvironment environment;
    private final MethodSupplier<PeripheralMethod> peripheralMethods;
    private final PeripheralWrapper[] peripherals = new PeripheralWrapper[6];
    private boolean running;

    public PeripheralAPI(IAPIEnvironment environment, MethodSupplier<PeripheralMethod> peripheralMethods) {
        this.environment = environment;
        this.peripheralMethods = peripheralMethods;
        this.environment.setPeripheralChangeListener(this);
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPeripheralChanged(ComputerSide side, @Nullable IPeripheral newPeripheral) {
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper wrapper;
            int index = side.ordinal();
            if (this.peripherals[index] != null) {
                wrapper = this.peripherals[index];
                if (wrapper.isAttached()) {
                    wrapper.detach();
                }
                this.environment.queueEvent("peripheral_detach", side.getName());
            }
            PeripheralWrapper peripheralWrapper = this.peripherals[index] = newPeripheral == null ? null : new PeripheralWrapper(newPeripheral, side.getName());
            if (this.peripherals[index] != null) {
                wrapper = this.peripherals[index];
                if (this.running && !wrapper.isAttached()) {
                    wrapper.attach();
                }
                this.environment.queueEvent("peripheral", side.getName());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String[] getNames() {
        return new String[]{"peripheral"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            this.running = true;
            for (int i = 0; i < 6; ++i) {
                PeripheralWrapper wrapper = this.peripherals[i];
                if (wrapper == null || wrapper.isAttached()) continue;
                wrapper.attach();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            this.running = false;
            for (int i = 0; i < 6; ++i) {
                PeripheralWrapper wrapper = this.peripherals[i];
                if (wrapper == null || !wrapper.isAttached()) continue;
                wrapper.detach();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaFunction
    public final boolean isPresent(String sideName) {
        ComputerSide side = ComputerSide.valueOfInsensitive(sideName);
        if (side == null) return false;
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper p = this.peripherals[side.ordinal()];
            if (p == null) return false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @LuaFunction
    public final Object[] getType(String sideName) {
        ComputerSide side = ComputerSide.valueOfInsensitive(sideName);
        if (side == null) {
            return null;
        }
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper p = this.peripherals[side.ordinal()];
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return p == null ? null : LuaUtil.consArray(p.getType(), p.getAdditionalTypes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @LuaFunction
    public final Object[] hasType(String sideName, String type) {
        ComputerSide side = ComputerSide.valueOfInsensitive(sideName);
        if (side == null) {
            return null;
        }
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper p = this.peripherals[side.ordinal()];
            if (p != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return new Object[]{p.getType().equals(type) || p.getAdditionalTypes().contains(type)};
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @LuaFunction
    public final Object[] getMethods(String sideName) {
        ComputerSide side = ComputerSide.valueOfInsensitive(sideName);
        if (side == null) {
            return null;
        }
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper p = this.peripherals[side.ordinal()];
            if (p != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new Object[]{p.getMethods()};
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final MethodResult call(ILuaContext context, IArguments args) throws LuaException {
        ComputerSide side = ComputerSide.valueOfInsensitive(args.getString(0));
        String methodName = args.getString(1);
        IArguments methodArgs = args.drop(2);
        if (side == null) {
            throw new LuaException("No peripheral attached");
        }
        PeripheralWrapper[] peripheralWrapperArray = this.peripherals;
        synchronized (this.peripherals) {
            PeripheralWrapper p = this.peripherals[side.ordinal()];
            // ** MonitorExit[var7_6] (shouldn't be in output)
            if (p == null) {
                throw new LuaException("No peripheral attached");
            }
            try {
                return p.call(context, methodName, methodArgs).adjustError(1);
            }
            catch (LuaException e) {
                if (e.getLevel() > 0) {
                    throw new FastLuaException(e.getMessage(), e.getLevel() + 1);
                }
                throw e;
            }
        }
    }

    private class PeripheralWrapper
    extends ComputerAccess {
        private final String side;
        private final IPeripheral peripheral;
        private final String type;
        private final Set<String> additionalTypes;
        private final Map<String, PeripheralMethod> methodMap;
        private boolean attached;

        PeripheralWrapper(IPeripheral peripheral, String side) {
            super(PeripheralAPI.this.environment);
            this.attached = false;
            this.side = side;
            this.peripheral = peripheral;
            this.type = Objects.requireNonNull(peripheral.getType(), "Peripheral type cannot be null");
            this.additionalTypes = peripheral.getAdditionalTypes();
            this.methodMap = PeripheralAPI.this.peripheralMethods.getSelfMethods(peripheral);
        }

        public IPeripheral getPeripheral() {
            return this.peripheral;
        }

        public String getType() {
            return this.type;
        }

        public Set<String> getAdditionalTypes() {
            return this.additionalTypes;
        }

        public Collection<String> getMethods() {
            return this.methodMap.keySet();
        }

        public synchronized boolean isAttached() {
            return this.attached;
        }

        public synchronized void attach() {
            this.attached = true;
            this.peripheral.attach(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detach() {
            this.peripheral.detach(this);
            PeripheralWrapper peripheralWrapper = this;
            synchronized (peripheralWrapper) {
                this.unmountAll();
            }
            this.attached = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MethodResult call(ILuaContext context, String methodName, IArguments arguments) throws LuaException {
            PeripheralMethod method;
            PeripheralWrapper peripheralWrapper = this;
            synchronized (peripheralWrapper) {
                method = this.methodMap.get(methodName);
            }
            if (method == null) {
                throw new LuaException("No such method " + methodName);
            }
            try (OperationTimer ignored = PeripheralAPI.this.environment.time(Metrics.PERIPHERAL_OPS);){
                MethodResult methodResult = method.apply(this.peripheral, context, this, arguments);
                return methodResult;
            }
        }

        @Override
        @Nullable
        public synchronized String mount(String desiredLoc, Mount mount, String driveName) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return super.mount(desiredLoc, mount, driveName);
        }

        @Override
        @Nullable
        public synchronized String mountWritable(String desiredLoc, WritableMount mount, String driveName) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return super.mountWritable(desiredLoc, mount, driveName);
        }

        @Override
        public synchronized void unmount(@Nullable String location) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            super.unmount(location);
        }

        @Override
        public int getID() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return super.getID();
        }

        @Override
        public void queueEvent(String event, Object ... arguments) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            super.queueEvent(event, arguments);
        }

        @Override
        public String getAttachmentName() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return this.side;
        }

        @Override
        public Map<String, IPeripheral> getAvailablePeripherals() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            HashMap<String, IPeripheral> peripherals = new HashMap<String, IPeripheral>();
            for (PeripheralWrapper wrapper : PeripheralAPI.this.peripherals) {
                if (wrapper == null || !wrapper.isAttached()) continue;
                peripherals.put(wrapper.getAttachmentName(), wrapper.getPeripheral());
            }
            return Collections.unmodifiableMap(peripherals);
        }

        @Override
        @Nullable
        public IPeripheral getAvailablePeripheral(String name) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            for (PeripheralWrapper wrapper : PeripheralAPI.this.peripherals) {
                if (wrapper == null || !wrapper.isAttached() || !wrapper.getAttachmentName().equals(name)) continue;
                return wrapper.getPeripheral();
            }
            return null;
        }

        @Override
        public WorkMonitor getMainThreadMonitor() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return super.getMainThreadMonitor();
        }
    }
}

