/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core;

import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.asm.LuaMethodSupplier;
import dan200.computercraft.core.asm.PeripheralMethodSupplier;
import dan200.computercraft.core.computer.GlobalEnvironment;
import dan200.computercraft.core.computer.computerthread.ComputerScheduler;
import dan200.computercraft.core.computer.computerthread.ComputerThread;
import dan200.computercraft.core.computer.mainthread.MainThreadScheduler;
import dan200.computercraft.core.computer.mainthread.NoWorkMainThreadScheduler;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.ILuaMachine;
import dan200.computercraft.core.methods.LuaMethod;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.methods.PeripheralMethod;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class ComputerContext {
    private final GlobalEnvironment globalEnvironment;
    private final ComputerScheduler computerScheduler;
    private final MainThreadScheduler mainThreadScheduler;
    private final ILuaMachine.Factory luaFactory;
    private final List<ILuaAPIFactory> apiFactories;
    private final MethodSupplier<LuaMethod> luaMethods;
    private final MethodSupplier<PeripheralMethod> peripheralMethods;

    ComputerContext(GlobalEnvironment globalEnvironment, ComputerScheduler computerScheduler, MainThreadScheduler mainThreadScheduler, ILuaMachine.Factory luaFactory, List<ILuaAPIFactory> apiFactories, MethodSupplier<LuaMethod> luaMethods, MethodSupplier<PeripheralMethod> peripheralMethods) {
        this.globalEnvironment = globalEnvironment;
        this.computerScheduler = computerScheduler;
        this.mainThreadScheduler = mainThreadScheduler;
        this.luaFactory = luaFactory;
        this.apiFactories = apiFactories;
        this.luaMethods = luaMethods;
        this.peripheralMethods = peripheralMethods;
    }

    public GlobalEnvironment globalEnvironment() {
        return this.globalEnvironment;
    }

    public ComputerScheduler computerScheduler() {
        return this.computerScheduler;
    }

    public MainThreadScheduler mainThreadScheduler() {
        return this.mainThreadScheduler;
    }

    public ILuaMachine.Factory luaFactory() {
        return this.luaFactory;
    }

    public List<ILuaAPIFactory> apiFactories() {
        return this.apiFactories;
    }

    public MethodSupplier<LuaMethod> luaMethods() {
        return this.luaMethods;
    }

    public MethodSupplier<PeripheralMethod> peripheralMethods() {
        return this.peripheralMethods;
    }

    @CheckReturnValue
    public boolean close(long timeout, TimeUnit unit) throws InterruptedException {
        return this.computerScheduler().stop(timeout, unit);
    }

    public void ensureClosed(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.computerScheduler().stop(timeout, unit)) {
            throw new IllegalStateException("Failed to shutdown ComputerContext in time.");
        }
    }

    public static Builder builder(GlobalEnvironment environment) {
        return new Builder(environment);
    }

    public static class Builder {
        private final GlobalEnvironment environment;
        @Nullable
        private ComputerScheduler computerScheduler = null;
        @Nullable
        private MainThreadScheduler mainThreadScheduler;
        @Nullable
        private ILuaMachine.Factory luaFactory;
        @Nullable
        private List<ILuaAPIFactory> apiFactories;
        @Nullable
        private List<GenericMethod> genericMethods;

        Builder(GlobalEnvironment environment) {
            this.environment = environment;
        }

        public Builder computerThreads(int threads) {
            if (threads < 1) {
                throw new IllegalArgumentException("Threads must be >= 1");
            }
            return this.computerScheduler(new ComputerThread(threads));
        }

        public Builder computerScheduler(ComputerScheduler scheduler) {
            Objects.requireNonNull(scheduler);
            if (this.computerScheduler != null) {
                throw new IllegalStateException("Computer scheduler already specified");
            }
            this.computerScheduler = scheduler;
            return this;
        }

        public Builder mainThreadScheduler(MainThreadScheduler scheduler) {
            Objects.requireNonNull(scheduler);
            if (this.mainThreadScheduler != null) {
                throw new IllegalStateException("Main-thread scheduler already specified");
            }
            this.mainThreadScheduler = scheduler;
            return this;
        }

        public Builder luaFactory(ILuaMachine.Factory factory) {
            Objects.requireNonNull(factory);
            if (this.luaFactory != null) {
                throw new IllegalStateException("Main-thread scheduler already specified");
            }
            this.luaFactory = factory;
            return this;
        }

        public Builder apiFactories(Collection<ILuaAPIFactory> apis) {
            Objects.requireNonNull(apis);
            if (this.apiFactories != null) {
                throw new IllegalStateException("Main-thread scheduler already specified");
            }
            this.apiFactories = List.copyOf(apis);
            return this;
        }

        public Builder genericMethods(Collection<GenericMethod> genericMethods) {
            Objects.requireNonNull(genericMethods);
            if (this.genericMethods != null) {
                throw new IllegalStateException("Main-thread scheduler already specified");
            }
            this.genericMethods = List.copyOf(genericMethods);
            return this;
        }

        public ComputerContext build() {
            return new ComputerContext(this.environment, this.computerScheduler == null ? new ComputerThread(1) : this.computerScheduler, this.mainThreadScheduler == null ? new NoWorkMainThreadScheduler() : this.mainThreadScheduler, this.luaFactory == null ? CobaltLuaMachine::new : this.luaFactory, this.apiFactories == null ? List.of() : this.apiFactories, LuaMethodSupplier.create(this.genericMethods == null ? List.of() : this.genericMethods), PeripheralMethodSupplier.create(this.genericMethods == null ? List.of() : this.genericMethods));
        }
    }
}

