/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.client.turtle;

import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.impl.client.ClientPlatformHelper;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

final class TurtleUpgradeModellers {
    private static final Transformation leftTransform = TurtleUpgradeModellers.getMatrixFor(-0.4065f);
    private static final Transformation rightTransform = TurtleUpgradeModellers.getMatrixFor(0.4065f);
    static final TurtleUpgradeModeller<ITurtleUpgrade> UPGRADE_ITEM = new UpgradeItemModeller();

    TurtleUpgradeModellers() {
    }

    private static Transformation getMatrixFor(float offset) {
        Matrix4f matrix = new Matrix4f();
        matrix.set(new float[]{0.0f, 0.0f, -1.0f, 1.0f + offset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        matrix.transpose();
        return new Transformation(matrix);
    }

    private static final class UpgradeItemModeller
    implements TurtleUpgradeModeller<ITurtleUpgrade> {
        private UpgradeItemModeller() {
        }

        @Override
        public TransformedModel getModel(ITurtleUpgrade upgrade, @Nullable ITurtleAccess turtle, TurtleSide side) {
            return this.getModel(turtle == null ? upgrade.getCraftingItem() : upgrade.getUpgradeItem(turtle.getUpgradeNBTData(side)), side);
        }

        @Override
        public TransformedModel getModel(ITurtleUpgrade upgrade, CompoundTag data, TurtleSide side) {
            return this.getModel(upgrade.getUpgradeItem(data), side);
        }

        private TransformedModel getModel(ItemStack stack, TurtleSide side) {
            BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(stack);
            if (stack.m_41790_()) {
                model = ClientPlatformHelper.get().createdFoiledModel(model);
            }
            return new TransformedModel(model, side == TurtleSide.LEFT ? leftTransform : rightTransform);
        }
    }
}

