/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.platform.RegistrationHelper;
import dan200.computercraft.shared.platform.RegistryWrappers;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface PlatformHelper
extends dan200.computercraft.impl.PlatformHelper {
    public static PlatformHelper get() {
        return (PlatformHelper)dan200.computercraft.impl.PlatformHelper.get();
    }

    public boolean isDevelopmentEnvironment();

    public ConfigFile.Builder createConfigBuilder();

    public <T> RegistryWrappers.RegistryWrapper<T> wrap(ResourceKey<Registry<T>> var1);

    public <T> RegistrationHelper<T> createRegistrationHelper(ResourceKey<Registry<T>> var1);

    @Nullable
    public <T> T tryGetRegistryObject(ResourceKey<Registry<T>> var1, ResourceLocation var2);

    public boolean shouldLoadResource(JsonObject var1);

    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> var1, Block var2);

    public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>, I extends ArgumentTypeInfo<A, T>> I registerArgumentTypeInfo(Class<A> var1, I var2);

    public <C extends AbstractContainerMenu, T extends ContainerData> MenuType<C> createMenuType(Function<FriendlyByteBuf, T> var1, ContainerData.Factory<C, T> var2);

    public void openMenu(Player var1, MenuProvider var2, ContainerData var3);

    public void sendToPlayer(NetworkMessage<ClientNetworkContext> var1, ServerPlayer var2);

    public void sendToPlayers(NetworkMessage<ClientNetworkContext> var1, Collection<ServerPlayer> var2);

    public void sendToAllPlayers(NetworkMessage<ClientNetworkContext> var1, MinecraftServer var2);

    public void sendToAllAround(NetworkMessage<ClientNetworkContext> var1, ServerLevel var2, Vec3 var3, float var4);

    public void sendToAllTracking(NetworkMessage<ClientNetworkContext> var1, LevelChunk var2);

    public ComponentAccess<IPeripheral> createPeripheralAccess(Consumer<Direction> var1);

    public ComponentAccess<WiredElement> createWiredElementAccess(Consumer<Direction> var1);

    public boolean hasWiredElementIn(Level var1, BlockPos var2, Direction var3);

    public ContainerTransfer.Slotted wrapContainer(Container var1);

    @Nullable
    public ContainerTransfer getContainer(ServerLevel var1, BlockPos var2, Direction var3);

    public RecipeIngredients getRecipeIngredients();

    public List<TagKey<Item>> getDyeTags();

    public int getBurnTime(ItemStack var1);

    public CreativeModeTab.Builder newCreativeModeTab();

    public ItemStack getCraftingRemainingItem(ItemStack var1);

    public List<ItemStack> getRecipeRemainingItems(ServerPlayer var1, Recipe<CraftingContainer> var2, CraftingContainer var3);

    public void onItemCrafted(ServerPlayer var1, CraftingContainer var2, ItemStack var3);

    public boolean onNotifyNeighbour(Level var1, BlockPos var2, BlockState var3, Direction var4);

    public ServerPlayer createFakePlayer(ServerLevel var1, GameProfile var2);

    default public boolean isFakePlayer(ServerPlayer player) {
        return player.f_8906_ == null || player.getClass() != ServerPlayer.class;
    }

    default public double getReachDistance(Player player) {
        return player.m_7500_() ? 5.0 : 4.5;
    }

    public boolean hasToolUsage(ItemStack var1);

    public InteractionResult canAttackEntity(ServerPlayer var1, Entity var2);

    public boolean interactWithEntity(ServerPlayer var1, Entity var2, Vec3 var3);

    public InteractionResult useOn(ServerPlayer var1, ItemStack var2, BlockHitResult var3, Predicate<BlockState> var4);
}

