/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.common.AbstractContainerBlockEntity;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveMenu;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDrivePeripheral;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.peripheral.diskdrive.MediaStack;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public final class DiskDriveBlockEntity
extends AbstractContainerBlockEntity {
    private static final String NBT_ITEM = "Item";
    private final DiskDrivePeripheral peripheral = new DiskDrivePeripheral(this);
    @GuardedBy(value="this")
    private final Map<IComputerAccess, MountInfo> computers = new HashMap<IComputerAccess, MountInfo>();
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private MediaStack media = MediaStack.EMPTY;
    @Nullable
    private Mount mount;
    private boolean recordPlaying = false;
    private final AtomicReference<RecordCommand> recordQueued = new AtomicReference<Object>(null);
    private final AtomicBoolean ejectQueued = new AtomicBoolean(false);
    private final AtomicBoolean mountQueued = new AtomicBoolean(false);

    public DiskDriveBlockEntity(BlockEntityType<DiskDriveBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    public void m_6339_() {
        this.updateItem();
    }

    public void m_7651_() {
        if (this.recordPlaying) {
            this.stopRecord();
        }
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)DiskDriveBlock.FACING);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.setDiskStack(nbt.m_128441_(NBT_ITEM) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_(NBT_ITEM)) : ItemStack.f_41583_);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ItemStack stack = this.getDiskStack();
        if (!stack.m_41619_()) {
            tag.m_128365_(NBT_ITEM, (Tag)stack.m_41739_(new CompoundTag()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverTick() {
        RecordCommand recordQueued;
        if (this.ejectQueued.getAndSet(false)) {
            this.ejectContents();
        }
        if ((recordQueued = (RecordCommand)this.recordQueued.getAndSet(null)) != null) {
            switch (recordQueued) {
                case PLAY: {
                    SoundEvent record = this.media.getAudio();
                    if (record == null) break;
                    this.recordPlaying = true;
                    String title = this.media.getAudioTitle();
                    this.sendMessage(new PlayRecordClientMessage(this.m_58899_(), record, title));
                    break;
                }
                case STOP: {
                    this.stopRecord();
                    this.recordPlaying = false;
                }
            }
        }
        if (this.mountQueued.get()) {
            DiskDriveBlockEntity diskDriveBlockEntity = this;
            synchronized (diskDriveBlockEntity) {
                this.mountAll();
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getContents() {
        return this.inventory;
    }

    public void m_6596_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.updateItem();
        }
        super.m_6596_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItem() {
        ItemStack newDisk = this.getDiskStack();
        if (ItemStack.m_150942_((ItemStack)newDisk, (ItemStack)this.media.stack)) {
            return;
        }
        MediaStack media = MediaStack.of(newDisk);
        if (newDisk.m_41619_()) {
            this.updateBlockState(DiskDriveState.EMPTY);
        } else {
            this.updateBlockState(media.media != null ? DiskDriveState.FULL : DiskDriveState.INVALID);
        }
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            if (!this.media.stack.m_41619_()) {
                for (Map.Entry<IComputerAccess, MountInfo> computer : this.computers.entrySet()) {
                    DiskDriveBlockEntity.unmountDisk(computer.getKey(), computer.getValue());
                }
            }
            if (this.recordPlaying) {
                this.stopRecord();
                this.recordPlaying = false;
            }
            this.mount = null;
            this.media = media;
            this.mountAll();
        }
    }

    ItemStack getDiskStack() {
        return this.m_8020_(0);
    }

    MediaStack getMedia() {
        return this.media;
    }

    void setDiskStack(ItemStack stack) {
        this.m_6836_(0, stack);
        this.m_6596_();
    }

    void updateDiskStack(ItemStack stack) {
        this.m_6836_(0, stack);
        if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.media.stack)) {
            this.media = MediaStack.of(stack);
            super.m_6596_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getDiskMountPath(IComputerAccess computer) {
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            MountInfo info = this.computers.get(computer);
            return info != null ? info.mountPath : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attach(IComputerAccess computer) {
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            MountInfo info = new MountInfo();
            this.computers.put(computer, info);
            this.mountQueued.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach(IComputerAccess computer) {
        DiskDriveBlockEntity diskDriveBlockEntity = this;
        synchronized (diskDriveBlockEntity) {
            DiskDriveBlockEntity.unmountDisk(computer, this.computers.remove(computer));
        }
    }

    void playDiskAudio() {
        this.recordQueued.set(RecordCommand.PLAY);
    }

    void stopDiskAudio() {
        this.recordQueued.set(RecordCommand.STOP);
    }

    void ejectDisk() {
        this.ejectQueued.set(true);
    }

    @GuardedBy(value="this")
    private void mountAll() {
        this.doMountAll();
        this.mountQueued.set(false);
    }

    @GuardedBy(value="this")
    private void doMountAll() {
        if (this.computers.isEmpty() || this.media.media == null) {
            return;
        }
        if (this.mount == null) {
            ItemStack stack = this.getDiskStack();
            this.mount = this.media.media.createDataMount(stack, (ServerLevel)this.f_58857_);
            this.setDiskStack(stack);
        }
        if (this.mount == null) {
            return;
        }
        for (Map.Entry<IComputerAccess, MountInfo> entry : this.computers.entrySet()) {
            IComputerAccess computer = entry.getKey();
            MountInfo info = entry.getValue();
            if (info.mountPath != null) continue;
            Mount mount = this.mount;
            if (mount instanceof WritableMount) {
                WritableMount writable = (WritableMount)mount;
                n = 1;
                while (info.mountPath == null) {
                    info.mountPath = computer.mountWritable((String)(n == 1 ? "disk" : "disk" + n), writable);
                    ++n;
                }
            } else {
                n = 1;
                while (info.mountPath == null) {
                    info.mountPath = computer.mount((String)(n == 1 ? "disk" : "disk" + n), this.mount);
                    ++n;
                }
            }
            computer.queueEvent("disk", computer.getAttachmentName());
        }
    }

    private static void unmountDisk(IComputerAccess computer, MountInfo info) {
        if (info.mountPath != null) {
            computer.unmount(info.mountPath);
            info.mountPath = null;
        }
        computer.queueEvent("disk_eject", computer.getAttachmentName());
    }

    private void updateBlockState(DiskDriveState state) {
        BlockState blockState = this.m_58900_();
        if (blockState.m_61143_(DiskDriveBlock.STATE) == state) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)blockState.m_61124_(DiskDriveBlock.STATE, (Comparable)((Object)state)));
    }

    private void ejectContents() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        ItemStack stack = this.getDiskStack();
        if (stack.m_41619_()) {
            return;
        }
        this.setDiskStack(ItemStack.f_41583_);
        WorldUtil.dropItemStack(this.m_58904_(), this.m_58899_(), this.getDirection(), stack);
        this.m_58904_().m_46796_(1000, this.m_58899_(), 0);
    }

    private void stopRecord() {
        this.sendMessage(new PlayRecordClientMessage(this.m_58899_()));
    }

    private void sendMessage(PlayRecordClientMessage message) {
        PlatformHelper.get().sendToAllAround(message, (ServerLevel)this.m_58904_(), Vec3.m_82512_((Vec3i)this.m_58899_()), 64.0f);
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new DiskDriveMenu(id, inventory, this);
    }

    private static enum RecordCommand {
        PLAY,
        STOP;

    }

    private static final class MountInfo {
        @Nullable
        String mountPath;

        private MountInfo() {
        }
    }
}

