/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.recipe;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.computer.recipe.ComputerConvertRecipe;
import dan200.computercraft.shared.recipe.ShapedRecipeSpec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class ComputerUpgradeRecipe
extends ComputerConvertRecipe {
    private final ComputerFamily family;

    private ComputerUpgradeRecipe(ResourceLocation identifier, ShapedRecipeSpec recipe, ComputerFamily family) {
        super(identifier, recipe);
        this.family = family;
    }

    @Override
    protected ItemStack convert(IComputerItem item, ItemStack stack) {
        return item.withFamily(stack, this.family);
    }

    public RecipeSerializer<ComputerUpgradeRecipe> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.COMPUTER_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ComputerUpgradeRecipe> {
        public ComputerUpgradeRecipe fromJson(ResourceLocation identifier, JsonObject json) {
            ShapedRecipeSpec recipe = ShapedRecipeSpec.fromJson(json);
            ComputerFamily family = ComputerFamily.getFamily(json, "family");
            return new ComputerUpgradeRecipe(identifier, recipe, family);
        }

        public ComputerUpgradeRecipe fromNetwork(ResourceLocation identifier, FriendlyByteBuf buf) {
            ShapedRecipeSpec recipe = ShapedRecipeSpec.fromNetwork(buf);
            ComputerFamily family = (ComputerFamily)buf.m_130066_(ComputerFamily.class);
            return new ComputerUpgradeRecipe(identifier, recipe, family);
        }

        public void toNetwork(FriendlyByteBuf buf, ComputerUpgradeRecipe recipe) {
            recipe.toSpec().toNetwork(buf);
            buf.m_130068_((Enum)recipe.family);
        }
    }
}

