/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.SerializeUtil;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class SpiceRecipe
extends IDataRecipe {
    public static List<SpiceRecipe> recipes;
    public static RegistryObject<RecipeType<Recipe<?>>> TYPE;
    public static RegistryObject<RecipeSerializer<?>> SERIALIZER;
    public Ingredient spice;
    public MobEffectInstance effect;
    public boolean canReactLead = false;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TYPE.get();
    }

    public SpiceRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        this.spice = Ingredient.m_43917_((JsonElement)jo.get("spice"));
        if (jo.has("effect")) {
            MobEffect eff;
            JsonObject x = jo.get("effect").getAsJsonObject();
            int amplifier = 0;
            if (x.has("level")) {
                amplifier = x.get("level").getAsInt();
            }
            int duration = 0;
            if (x.has("time")) {
                duration = x.get("time").getAsInt();
            }
            if ((eff = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(x.get("effect").getAsString()))) != null) {
                this.effect = new MobEffectInstance(eff, duration, amplifier);
            }
        }
        if (jo.has("reacts_lead")) {
            this.canReactLead = jo.get("reacts_lead").getAsBoolean();
        }
    }

    public SpiceRecipe(ResourceLocation id, FriendlyByteBuf pb) {
        super(id);
        this.spice = Ingredient.m_43940_((FriendlyByteBuf)pb);
        this.effect = SerializeUtil.readOptional(pb, b -> MobEffectInstance.m_19560_((CompoundTag)b.m_130260_())).orElse(null);
        this.canReactLead = pb.readBoolean();
    }

    public SpiceRecipe(ResourceLocation id, Ingredient spice, MobEffectInstance effect) {
        super(id);
        this.spice = spice;
        this.effect = effect;
    }

    public SpiceRecipe(ResourceLocation id, Ingredient spice, MobEffectInstance effect, boolean canReactLead) {
        super(id);
        this.spice = spice;
        this.effect = effect;
        this.canReactLead = canReactLead;
    }

    public void write(FriendlyByteBuf pack) {
        this.spice.m_43923_(pack);
        SerializeUtil.writeOptional(pack, this.effect, (e, b) -> b.m_130079_(e.m_19555_(new CompoundTag())));
        pack.writeBoolean(this.canReactLead);
    }

    @Override
    public void serializeRecipeData(JsonObject jx) {
        jx.add("spice", this.spice.m_43942_());
        if (this.effect != null) {
            JsonObject jo = new JsonObject();
            jo.addProperty("level", (Number)this.effect.m_19564_());
            jo.addProperty("time", (Number)this.effect.m_19557_());
            jo.addProperty("effect", Utils.getRegistryName(this.effect.m_19544_()).toString());
            jx.add("effect", (JsonElement)jo);
        }
        jx.addProperty("reacts_lead", Boolean.valueOf(this.canReactLead));
    }

    public static int getMaxUse(ItemStack spice) {
        return spice.m_41776_() - spice.m_41773_();
    }

    public static ItemStack handle(ItemStack spice, int cnt) {
        int cdmg = spice.m_41773_();
        if ((cdmg += cnt) >= spice.m_41776_()) {
            return spice.getCraftingRemainingItem();
        }
        spice.m_41721_(cdmg);
        return spice;
    }

    public static SpiceRecipe find(ItemStack spice) {
        return recipes.stream().filter(e -> e.spice.test(spice)).findFirst().orElse(null);
    }

    public static boolean isValid(ItemStack spice) {
        return recipes.stream().anyMatch(e -> e.spice.test(spice));
    }
}

