/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.api;

import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.item.DishItem;
import com.teammoeg.caupona.item.StewItem;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.IFoodInfo;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class CauponaHooks {
    public static final ResourceLocation stew = new ResourceLocation("caupona", "stews");

    private CauponaHooks() {
    }

    public static Optional<List<FloatemStack>> getItems(ItemStack stack) {
        if (stack.m_41720_() instanceof StewItem) {
            return Optional.of(StewItem.getItems(stack));
        }
        LazyOptional cap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (cap.isPresent()) {
            IFluidHandlerItem data = (IFluidHandlerItem)cap.resolve().get();
            FluidStack fs = data.getFluidInTank(0);
            return Optional.of(SoupFluid.getItems(fs));
        }
        if (stack.m_41720_() instanceof DishItem) {
            return Optional.of(DishItem.getItems(stack));
        }
        return Optional.empty();
    }

    public static ResourceLocation getBase(ItemStack stack) {
        LazyOptional cap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (cap.isPresent()) {
            IFluidHandlerItem data = (IFluidHandlerItem)cap.resolve().get();
            return SoupFluid.getBase(data.getFluidInTank(0));
        }
        if (Utils.getFluidType(stack) != Fluids.f_76191_) {
            return StewItem.getBase(stack);
        }
        return new ResourceLocation("water");
    }

    public static Optional<IFoodInfo> getInfo(ItemStack stack) {
        if (stack.m_41720_() instanceof StewItem) {
            return Optional.of(StewItem.getInfo(stack));
        }
        LazyOptional cap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (cap.isPresent()) {
            IFluidHandlerItem data = (IFluidHandlerItem)cap.resolve().get();
            return Optional.of(SoupFluid.getInfo(data.getFluidInTank(0)));
        }
        if (stack.m_41720_() instanceof DishItem) {
            return Optional.of(DishItem.getInfo(stack));
        }
        return Optional.empty();
    }
}

