/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.item;

import com.google.common.collect.Lists;
import com.teammoeg.caupona.blocks.foods.DishBlock;
import com.teammoeg.caupona.item.EdibleBlock;
import com.teammoeg.caupona.util.FloatemStack;
import com.teammoeg.caupona.util.SauteedFoodInfo;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class DishItem
extends EdibleBlock {
    public static final FoodProperties fakefood = new FoodProperties.Builder().m_38760_(4).m_38758_(0.2f).m_38757_().m_38767_();
    public final DishBlock bl;

    public DishItem(DishBlock block, Item.Properties props) {
        super(block, props.m_41489_(fakefood));
        this.bl = block;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.EAT;
    }

    public static List<FloatemStack> getItems(ItemStack stack) {
        CompoundTag soupTag;
        if (stack.m_41782_() && (soupTag = stack.m_41737_("dish")) != null) {
            return SauteedFoodInfo.getStacks(soupTag);
        }
        return Lists.newArrayList();
    }

    public static SauteedFoodInfo getInfo(ItemStack stack) {
        CompoundTag soupTag;
        if (stack.m_41782_() && (soupTag = stack.m_41737_("dish")) != null) {
            return new SauteedFoodInfo(soupTag);
        }
        return new SauteedFoodInfo();
    }

    public static void setInfo(ItemStack stack, SauteedFoodInfo current) {
        if (!current.isEmpty()) {
            stack.m_41784_().m_128365_("dish", (Tag)current.save());
        }
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ResourceLocation rl;
        SauteedFoodInfo info = DishItem.getInfo(stack);
        FloatemStack fs = info.stacks.stream().max((t1, t2) -> t1.getCount() > t2.getCount() ? 1 : (t1.getCount() == t2.getCount() ? 0 : -1)).orElse(null);
        if (fs != null) {
            tooltip.add((Component)Utils.translate("tooltip.caupona.main_ingredient", fs.getStack().m_41611_()));
        }
        if ((rl = info.spiceName) != null) {
            tooltip.add((Component)Utils.translate("tooltip.caupona.spice", Utils.translate("spice." + rl.m_135827_() + "." + rl.m_135815_())));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public FoodProperties getFoodProperties(ItemStack stack, LivingEntity entity) {
        return DishItem.getInfo(stack).getFood();
    }
}

