/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.teammoeg.caupona.data.SerializeUtil;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.Writeable;
import com.teammoeg.caupona.data.recipes.ComplexCalculated;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.data.recipes.numbers.Numbers;
import com.teammoeg.caupona.util.FloatemTagStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class Add
implements CookIngredients,
ComplexCalculated {
    List<CookIngredients> nums;

    public Add(JsonElement jo) {
        if (jo.isJsonObject()) {
            this.nums = SerializeUtil.parseJsonElmList((JsonElement)jo.getAsJsonObject().get("types").getAsJsonArray(), Numbers::of);
        } else if (jo.isJsonArray()) {
            this.nums = SerializeUtil.parseJsonElmList((JsonElement)jo.getAsJsonArray(), Numbers::of);
        }
    }

    public Add() {
        this(new ArrayList<CookIngredients>());
    }

    public Add(List<CookIngredients> nums) {
        this.nums = nums;
    }

    @Override
    public Float apply(IPendingContext t) {
        return this.nums.stream().map(t::compute).reduce(Float.valueOf(0.0f), Float::sum);
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return this.nums.stream().anyMatch(s -> s.fits(stack));
    }

    public void add(CookIngredients sn) {
        this.nums.add(sn);
    }

    @Override
    public JsonElement serialize() {
        return SerializeUtil.toJsonList(this.nums, Writeable::serialize);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        SerializeUtil.writeList(buffer, this.nums, Numbers::write);
    }

    public Add(FriendlyByteBuf buffer) {
        this.nums = SerializeUtil.readList(buffer, Numbers::of);
    }

    @Override
    public String getType() {
        return "add";
    }

    @Override
    public Stream<CookIngredients> getItemRelated() {
        return this.nums.stream().flatMap(CookIngredients::getItemRelated);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nums == null ? 0 : this.nums.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Add)) {
            return false;
        }
        Add other = (Add)obj;
        return !(this.nums == null ? other.nums != null : !this.nums.equals(other.nums));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return this.nums.stream().flatMap(CookIngredients::getTags);
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return this.nums.stream().map(e -> e.getTranslation(p)).reduce((s1, s2) -> s1 + "+" + s2).orElse("");
    }

    @Override
    public Stream<ItemStack> getStacks() {
        return this.nums.stream().flatMap(CookIngredients::getStacks);
    }
}

