/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.baseconditions;

import com.google.gson.JsonObject;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.StewBaseCondition;
import com.teammoeg.caupona.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidType
implements StewBaseCondition {
    ResourceLocation of;

    public FluidType(JsonObject jo) {
        this.of = new ResourceLocation(jo.get("fluid").getAsString());
    }

    public FluidType(ResourceLocation of) {
        this.of = of;
    }

    public FluidType(Fluid of) {
        this.of = Utils.getRegistryName(of);
    }

    @Override
    public Integer apply(ResourceLocation t, ResourceLocation u) {
        return this.test(u) ? 2 : (this.test(t) ? 1 : 0);
    }

    @Override
    public boolean test(ResourceLocation t) {
        return this.of.equals((Object)t);
    }

    @Override
    public boolean test(Fluid f) {
        return Utils.getRegistryName(f).equals((Object)this.of);
    }

    @Override
    public JsonObject serialize() {
        JsonObject jo = new JsonObject();
        jo.addProperty("fluid", this.of.toString());
        return jo;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.of);
    }

    public FluidType(FriendlyByteBuf buffer) {
        this.of = buffer.m_130281_();
    }

    @Override
    public String getType() {
        return "fluid";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.of == null ? 0 : this.of.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FluidType)) {
            return false;
        }
        FluidType other = (FluidType)obj;
        return !(this.of == null ? other.of != null : !this.of.equals((Object)other.of));
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation(((Fluid)ForgeRegistries.FLUIDS.getValue(this.of)).getFluidType().getDescriptionId(), new Object[0]);
    }
}

