/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.plants;

import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.CPTags;
import com.teammoeg.caupona.blocks.plants.FruitBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;

public class SnailBlock
extends FruitBlock {
    public static final BooleanProperty EATEN_FRUIT = BooleanProperty.m_61465_((String)"plump");
    private static final BlockPos[] NEIGH = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1)};
    private static final int[] ORDER = new int[]{0, -1, 1};

    public SnailBlock(BlockBehaviour.Properties p_52247_) {
        super(p_52247_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_((Property)EATEN_FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7494_()).m_204336_(CPTags.Blocks.SNAIL_GROWABLE_ON);
    }

    public boolean m_6724_(BlockState pState) {
        return true;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return false;
    }

    @Override
    public int m_7419_() {
        return 4;
    }

    public int getMaxAge(BlockState state) {
        return (Boolean)state.m_61143_((Property)EATEN_FRUIT) != false ? 4 : 3;
    }

    public BlockState getStateForAge(BlockState orig, int pAge) {
        return (BlockState)orig.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(pAge));
    }

    @Override
    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos growable;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        int i = this.m_52305_(pState);
        if (i < this.getMaxAge(pState)) {
            int eat;
            if (ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_(3) == 0 ? 1 : 0) != 0) && (eat = this.eatFirstEdible(pPos, pLevel)) > 0) {
                if (eat == 2) {
                    pState = (BlockState)pState.m_61124_((Property)EATEN_FRUIT, (Comparable)Boolean.valueOf(true));
                }
                pLevel.m_7731_(pPos, this.getStateForAge(pState, i + 1), 2);
                ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        } else if (pRandom.m_188503_(3) == 0 && (growable = this.findGrowableBlock(pPos, pLevel)) != null) {
            BlockState state = pLevel.m_8055_(growable);
            int eat = this.eatFirstEdible(pPos, pLevel);
            if (eat > 0) {
                if (state.m_204336_(CPTags.Blocks.SNAIL_FOOD) || eat == 2) {
                    this.trySpread(growable, pLevel);
                } else if (pRandom.m_188503_(2) == 0) {
                    this.trySpread(growable, pLevel);
                }
            }
        }
    }

    public BlockPos findGrowableBlock(BlockPos pos, ServerLevel level) {
        for (BlockPos bp : NEIGH) {
            BlockState down;
            BlockPos cur = pos.m_121955_((Vec3i)bp);
            if (!this.m_7898_(this.m_49966_(), (LevelReader)level, cur) || !(down = level.m_8055_(cur)).m_60713_(Blocks.f_50016_) && !down.m_247087_() && !down.m_204336_(CPTags.Blocks.SNAIL_FOOD)) continue;
            return cur;
        }
        return null;
    }

    public void trySpread(BlockPos pos, ServerLevel level) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 0);
        if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_)) {
            level.m_7731_(pos.m_7494_(), ((Block)CPBlocks.SNAIL_MUCUS.get()).m_49966_(), 2);
        }
        level.m_7731_(pos, this.m_49966_(), 2);
    }

    public int eatFirstEdible(BlockPos pos, ServerLevel level) {
        int res = this.eatBlock(pos.m_7494_(), level, true);
        if (res > 0) {
            return res;
        }
        for (int x : ORDER) {
            for (int z : ORDER) {
                res = this.eatBlock(pos.m_7918_(x, 0, z), level, false);
                if (res <= 0) continue;
                return res;
            }
        }
        for (int y = 2; y > 0; --y) {
            for (int x : ORDER) {
                for (int z : ORDER) {
                    res = this.eatBlock(pos.m_7918_(x, y, z), level, y == 1 && x == 0 && z == 0);
                    if (res <= 0) continue;
                    return res;
                }
            }
        }
        return 0;
    }

    public int eatBlock(BlockPos pos, ServerLevel level, boolean toMucus) {
        BlockState bs = level.m_8055_(pos);
        if (bs.m_204336_(CPTags.Blocks.SNAIL_FOOD)) {
            Block blk = bs.m_60734_();
            boolean isplump = bs.m_204336_(CPTags.Blocks.SNAIL_PLUMP_FOOD);
            if (blk instanceof CropBlock) {
                CropBlock cb = (CropBlock)blk;
                if (cb.m_52307_(bs)) {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                    return isplump ? 2 : 1;
                }
            } else {
                if (toMucus || level.m_8055_(pos.m_7495_()).m_60713_((Block)CPBlocks.SNAIL.get())) {
                    level.m_7731_(pos, ((Block)CPBlocks.SNAIL_MUCUS.get()).m_49966_(), 2);
                    return isplump ? 2 : 1;
                }
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                return isplump ? 2 : 1;
            }
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_52244_, EATEN_FRUIT});
    }
}

