/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.blocks.foods;

import com.teammoeg.caupona.CPBlockEntityTypes;
import com.teammoeg.caupona.CPBlocks;
import com.teammoeg.caupona.blocks.CPRegisteredEntityBlock;
import com.teammoeg.caupona.blocks.foods.DishBlockEntity;
import com.teammoeg.caupona.item.DishItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class DishBlock
extends CPRegisteredEntityBlock<DishBlockEntity> {
    public static final IntegerProperty PAN = IntegerProperty.m_61631_((String)"pan", (int)0, (int)2);
    static final VoxelShape shape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public DishBlock(BlockBehaviour.Properties blockProps) {
        super(blockProps, CPBlockEntityTypes.DISH);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PAN, (Comparable)Integer.valueOf(0)));
        CPBlocks.dishes.add(this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PAN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)PAN, (Comparable)Integer.valueOf(0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.m_60734_() instanceof DishBlock)) {
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof DishBlockEntity) {
                DishBlockEntity dish = (DishBlockEntity)blockEntity;
                CPRegisteredEntityBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)dish.internal);
            }
            worldIn.m_46747_(pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        InteractionResult p = super.m_6227_(state, worldIn, pos, player, handIn, hit);
        if (p.m_19077_()) {
            return p;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof DishBlockEntity) {
            DishBlockEntity dish = (DishBlockEntity)blockEntity;
            if (dish.internal != null && dish.internal.m_41720_() instanceof DishItem && dish.internal.m_41614_()) {
                FoodProperties fp = dish.internal.getFoodProperties((LivingEntity)player);
                if (dish.isInfinite) {
                    if (player.m_36391_(fp.m_38747_())) {
                        player.m_5584_(worldIn, dish.internal.m_41777_());
                        dish.syncData();
                    }
                } else if (player.m_36391_(fp.m_38747_())) {
                    ItemStack iout = dish.internal.getCraftingRemainingItem();
                    player.m_5584_(worldIn, dish.internal);
                    dish.internal = iout;
                    if (dish.internal.m_150930_(Items.f_42399_)) {
                        worldIn.m_46597_(pos, ((DishBlock)CPBlocks.DISH.get()).m_49966_());
                    } else {
                        worldIn.m_7471_(pos, false);
                    }
                    dish.syncData();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof DishBlockEntity) {
            DishBlockEntity dish = (DishBlockEntity)blockEntity;
            dish.internal = ItemHandlerHelper.copyStackWithSize((ItemStack)pStack, (int)1);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DishBlockEntity) {
            DishBlockEntity dish = (DishBlockEntity)blockEntity;
            if (dish.internal == null) {
                return ItemStack.f_41583_;
            }
            return dish.internal.m_41777_();
        }
        return this.getCloneItemStack(state, target, level, pos, player);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof DishBlockEntity) {
            DishBlockEntity dish = (DishBlockEntity)blockEntity;
            if (dish.internal != null && !dish.internal.m_41619_() && dish.internal.m_41614_()) {
                return 15;
            }
        }
        return 0;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }
}

