/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.screen;

import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.ExactModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.TypeSideButton;
import com.ultramega.cabletiers.blockentity.TieredExporterBlockEntity;
import com.ultramega.cabletiers.container.TieredExporterContainerMenu;
import com.ultramega.cabletiers.node.TieredExporterNetworkNode;
import com.ultramega.cabletiers.screen.TieredScreen;
import com.ultramega.cabletiers.util.MathUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class TieredExporterScreen
extends TieredScreen<TieredExporterBlockEntity, TieredExporterContainerMenu, TieredExporterNetworkNode> {
    private boolean hasRegulatorMode = this.hasRegulatorMode();

    public TieredExporterScreen(TieredExporterContainerMenu container, Inventory inventory, Component title) {
        super(container, 211, 119 + 18 * MathUtil.ceilDiv(9 * container.getTier().getSlotsMultiplier(), 9), inventory, title);
    }

    private boolean hasRegulatorMode() {
        return ((TieredExporterNetworkNode)((Object)this.getNode())).getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR);
    }

    public void onPostInit(int x, int y) {
        this.addSideButton((SideButton)new RedstoneModeSideButton((BaseScreen)this, NetworkNodeBlockEntity.REDSTONE_MODE));
        this.addSideButton((SideButton)new TypeSideButton((BaseScreen)this, TieredExporterBlockEntity.TYPE));
        this.addSideButton((SideButton)new ExactModeSideButton((BaseScreen)this, TieredExporterBlockEntity.COMPARE));
    }

    @Override
    public void tick(int x, int y) {
        boolean updatedHasRegulatorMode = this.hasRegulatorMode();
        if (this.hasRegulatorMode != updatedHasRegulatorMode) {
            this.hasRegulatorMode = updatedHasRegulatorMode;
            ((TieredExporterContainerMenu)this.f_97732_).initSlots();
        }
    }

    public void renderBackground(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        graphics.m_280218_(new ResourceLocation("cabletiers", "textures/gui/" + this.getTier().getName() + "_exporter_importer_destructor.png"), x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void renderForeground(GuiGraphics graphics, int i, int i1) {
        this.renderString(graphics, 7, 7, this.f_96539_.getString());
        this.renderString(graphics, 7, 24 + 18 * MathUtil.ceilDiv(9 * this.getTier().getSlotsMultiplier(), 9), I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
    }
}

