/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.node.diskmanipulator;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.blockentity.DiskManipulatorBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.ProxyItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.StorageDiskItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.ContentType;
import com.ultramega.cabletiers.node.TieredNetworkNode;
import com.ultramega.cabletiers.node.diskmanipulator.TieredStorageDiskFluidManipulatorWrapper;
import com.ultramega.cabletiers.node.diskmanipulator.TieredStorageDiskItemManipulatorWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TieredDiskManipulatorNetworkNode
extends TieredNetworkNode<TieredDiskManipulatorNetworkNode>
implements IComparable,
IWhitelistBlacklist,
IType,
IStorageDiskContainerContext {
    public static final int IO_MODE_INSERT = 0;
    public static final int IO_MODE_EXTRACT = 1;
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_IO_MODE = "IOMode";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 9;
    private final IStorageDisk<ItemStack>[] itemDisks = new IStorageDisk[6 * this.checkTierMultiplier()];
    private final IStorageDisk<FluidStack>[] fluidDisks = new IStorageDisk[6 * this.checkTierMultiplier()];
    private final BaseItemHandler inputDisks = new BaseItemHandler(3 * this.checkTierMultiplier()).addValidator((Predicate)new StorageDiskItemValidator()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
        if (!this.level.f_46443_) {
            StackUtils.createStorages((ServerLevel)((ServerLevel)this.level), (ItemStack)handler.getStackInSlot(slot), (int)slot, this.itemDisks, this.fluidDisks, s -> new TieredStorageDiskItemManipulatorWrapper(this, (IStorageDisk<ItemStack>)s), s -> new TieredStorageDiskFluidManipulatorWrapper(this, (IStorageDisk<FluidStack>)s));
            if (!reading) {
                LevelUtils.updateBlock((Level)this.level, (BlockPos)this.pos);
            }
        }
    });
    private final BaseItemHandler outputDisks = new BaseItemHandler(3 * this.checkTierMultiplier()).addValidator((Predicate)new StorageDiskItemValidator()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
        if (!this.level.f_46443_) {
            StackUtils.createStorages((ServerLevel)((ServerLevel)this.level), (ItemStack)handler.getStackInSlot(slot), (int)(3 * this.checkTierMultiplier() + slot), this.itemDisks, this.fluidDisks, s -> new TieredStorageDiskItemManipulatorWrapper(this, (IStorageDisk<ItemStack>)s), s -> new TieredStorageDiskFluidManipulatorWrapper(this, (IStorageDisk<FluidStack>)s));
            if (!reading) {
                LevelUtils.updateBlock((Level)this.level, (BlockPos)this.pos);
            }
        }
    });
    private final ProxyItemHandler disks = new ProxyItemHandler((IItemHandler)this.inputDisks, (IItemHandler)this.outputDisks);
    private final BaseItemHandler itemFilters = new BaseItemHandler(9 * this.checkTierMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(9 * this.checkTierMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, this.getTierUpgrades()){

        public int getStackInteractCount() {
            int count = TieredDiskManipulatorNetworkNode.this.getTieredStackInteractCount(this);
            if (TieredDiskManipulatorNetworkNode.this.type == 1) {
                count *= 1000;
            }
            return count;
        }
    }.addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private int ioMode = 0;
    private final double speedMultiplier = this.getSpeedMultiplier(4);

    public TieredDiskManipulatorNetworkNode(Level level, BlockPos pos, CableTier tier) {
        super(level, pos, ContentType.DISK_MANIPULATOR, tier);
    }

    private UpgradeItem.Type[] getTierUpgrades() {
        UpgradeItem.Type[] typeArray;
        switch (this.getTier()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ELITE: {
                UpgradeItem.Type[] typeArray2 = new UpgradeItem.Type[2];
                typeArray2[0] = UpgradeItem.Type.SPEED;
                typeArray = typeArray2;
                typeArray2[1] = UpgradeItem.Type.STACK;
                break;
            }
            case ULTRA: 
            case MEGA: {
                UpgradeItem.Type[] typeArray3 = new UpgradeItem.Type[1];
                typeArray = typeArray3;
                typeArray3[0] = UpgradeItem.Type.SPEED;
            }
        }
        return typeArray;
    }

    public int getEnergyUsage() {
        return 4 * (RS.SERVER_CONFIG.getDiskManipulator().getUsage() + this.upgrades.getEnergyUsage()) * this.getAdditionalEnergyCost();
    }

    public void update() {
        super.update();
        if (!this.canUpdate()) {
            return;
        }
        int speed = Math.max(0, this.upgrades.getSpeed((int)(9.0 / this.speedMultiplier), 2));
        if (speed != 0 && this.ticks % speed != 0) {
            return;
        }
        if (this.type == 0) {
            for (slot = 0; slot < 3 * this.checkTierMultiplier() && (this.itemDisks[slot] == null || this.isItemDiskDone(this.itemDisks[slot], slot)); ++slot) {
            }
            if (slot == 3 * this.checkTierMultiplier()) {
                return;
            }
            IStorageDisk<ItemStack> storage = this.itemDisks[slot];
            if (this.ioMode == 0) {
                this.insertItemIntoNetwork(storage);
            } else if (this.ioMode == 1) {
                this.extractItemFromNetwork(storage, slot);
            }
        } else if (this.type == 1) {
            while (slot < 3 * this.checkTierMultiplier() && (this.fluidDisks[slot] == null || this.isFluidDiskDone(this.fluidDisks[slot], slot))) {
                ++slot;
            }
            if (slot == 3 * this.checkTierMultiplier()) {
                return;
            }
            IStorageDisk<FluidStack> storage = this.fluidDisks[slot];
            if (this.ioMode == 0) {
                this.insertFluidIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractFluidFromNetwork(storage, slot);
            }
        }
    }

    private void insertItemIntoNetwork(IStorageDisk<ItemStack> storage) {
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (ItemStack stack : stacks) {
            ItemStack extracted = (ItemStack)storage.extract((Object)stack, this.getTieredStackInteractCount(this.upgrades), this.compare, Action.PERFORM);
            if (extracted.m_41619_()) continue;
            ItemStack remainder = this.network.insertItem(extracted, extracted.m_41613_(), Action.PERFORM);
            if (remainder.m_41619_()) break;
            storage.insert((Object)(extracted == remainder ? remainder.m_41777_() : remainder), remainder.m_41613_(), Action.PERFORM);
        }
    }

    private boolean isItemDiskDone(IStorageDisk<ItemStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (ItemStack stack : stacks) {
            ItemStack remainder;
            ItemStack extracted = (ItemStack)storage.extract((Object)stack, this.getTieredStackInteractCount(this.upgrades), this.compare, Action.SIMULATE);
            if (extracted.m_41619_() || !(remainder = this.network.insertItem(extracted, extracted.m_41613_(), Action.SIMULATE)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void extractItemFromNetwork(IStorageDisk<ItemStack> storage, int slot) {
        ItemStack extracted = ItemStack.f_41583_;
        int i = 0;
        if (this.itemFilters.isEmpty()) {
            ItemStack toExtract = null;
            List networkItems = this.network.getItemStorageCache().getList().getStacks().stream().map(StackListEntry::getStack).collect(Collectors.toList());
            int j = 0;
            while ((toExtract == null || toExtract.m_41619_()) && j < networkItems.size()) {
                toExtract = (ItemStack)networkItems.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractItem(toExtract, this.getTieredStackInteractCount(this.upgrades), this.compare, Action.PERFORM);
            }
        } else {
            while (this.itemFilters.getSlots() > i && extracted.m_41619_()) {
                ItemStack filterStack = ItemStack.f_41583_;
                while (this.itemFilters.getSlots() > i && filterStack.m_41619_()) {
                    filterStack = this.itemFilters.getStackInSlot(i++);
                }
                if (filterStack.m_41619_()) continue;
                extracted = this.network.extractItem(filterStack, this.getTieredStackInteractCount(this.upgrades), this.compare, Action.PERFORM);
            }
        }
        if (extracted.m_41619_()) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack remainder = (ItemStack)storage.insert((Object)extracted, extracted.m_41613_(), Action.PERFORM);
        this.network.insertItem(remainder, remainder.m_41613_(), Action.PERFORM);
    }

    private void insertFluidIntoNetwork(IStorageDisk<FluidStack> storage, int slot) {
        ArrayList stacks = new ArrayList(storage.getStacks());
        FluidStack extracted = FluidStack.EMPTY;
        int i = 0;
        while (extracted.isEmpty() && stacks.size() > i) {
            FluidStack stack = (FluidStack)stacks.get(i++);
            extracted = (FluidStack)storage.extract((Object)stack, this.getTieredStackInteractCount(this.upgrades), this.compare, Action.PERFORM);
        }
        if (extracted.isEmpty()) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = this.network.insertFluid(extracted, extracted.getAmount(), Action.PERFORM);
        storage.insert((Object)remainder, remainder.getAmount(), Action.PERFORM);
    }

    private boolean isFluidDiskDone(IStorageDisk<FluidStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (FluidStack stack : stacks) {
            FluidStack remainder;
            FluidStack extracted = (FluidStack)storage.extract((Object)stack, this.getTieredStackInteractCount(this.upgrades), this.compare, Action.SIMULATE);
            if (extracted.isEmpty() || !(remainder = this.network.insertFluid(extracted, extracted.getAmount(), Action.SIMULATE)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void extractFluidFromNetwork(IStorageDisk<FluidStack> storage, int slot) {
        FluidStack extracted = FluidStack.EMPTY;
        int i = 0;
        if (this.fluidFilters.isEmpty()) {
            FluidStack toExtract = null;
            List networkFluids = this.network.getFluidStorageCache().getList().getStacks().stream().map(StackListEntry::getStack).collect(Collectors.toList());
            int j = 0;
            while ((toExtract == null || toExtract.getAmount() == 0) && j < networkFluids.size()) {
                toExtract = (FluidStack)networkFluids.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractFluid(toExtract, this.getTieredStackInteractCount(this.upgrades), this.compare, Action.PERFORM);
            }
        } else {
            while (this.fluidFilters.getSlots() > i && extracted.isEmpty()) {
                FluidStack filterStack = FluidStack.EMPTY;
                while (this.fluidFilters.getSlots() > i && filterStack.isEmpty()) {
                    filterStack = this.fluidFilters.getFluid(i++);
                }
                if (filterStack.isEmpty()) continue;
                extracted = this.network.extractFluid(filterStack, this.getTieredStackInteractCount(this.upgrades), this.compare, Action.PERFORM);
            }
        }
        if (extracted.isEmpty()) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = (FluidStack)storage.insert((Object)extracted, extracted.getAmount(), Action.PERFORM);
        this.network.insertFluid(remainder, remainder.getAmount(), Action.PERFORM);
    }

    private void moveDriveToOutput(int slot) {
        ItemStack disk = this.inputDisks.getStackInSlot(slot);
        if (!disk.m_41619_()) {
            int i;
            for (i = 0; i < 3 * this.checkTierMultiplier() && !this.outputDisks.getStackInSlot(i).m_41619_(); ++i) {
            }
            if (i == 3 * this.checkTierMultiplier()) {
                return;
            }
            this.inputDisks.extractItem(slot, 1, false);
            this.outputDisks.insertItem(i, disk, false);
        }
    }

    public DiskState[] getDiskState() {
        DiskState[] diskStates = new DiskState[6 * this.checkTierMultiplier()];
        for (int i = 0; i < 6 * this.checkTierMultiplier(); ++i) {
            DiskState state = DiskState.NONE;
            if (this.itemDisks[i] != null || this.fluidDisks[i] != null) {
                state = !this.canUpdate() ? DiskState.DISCONNECTED : DiskState.get((int)(this.itemDisks[i] != null ? this.itemDisks[i].getStored() : this.fluidDisks[i].getStored()), (int)(this.itemDisks[i] != null ? this.itemDisks[i].getCapacity() : this.fluidDisks[i].getCapacity()));
            }
            diskStates[i] = state;
        }
        return diskStates;
    }

    private int checkTierMultiplier() {
        return switch (this.getTier()) {
            default -> throw new IncompatibleClassChangeError();
            case CableTier.ELITE -> 2;
            case CableTier.ULTRA -> 3;
            case CableTier.MEGA -> 4;
        };
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
    }

    public int getType() {
        return this.level.f_46443_ ? (Integer)DiskManipulatorBlockEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
    }

    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public int getIoMode() {
        return this.ioMode;
    }

    public void setIoMode(int ioMode) {
        this.ioMode = ioMode;
    }

    public IItemHandler getInputDisks() {
        return this.inputDisks;
    }

    public IItemHandler getOutputDisks() {
        return this.outputDisks;
    }

    public ProxyItemHandler getDisks() {
        return this.disks;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)3, (CompoundTag)tag);
        StackUtils.readItems((BaseItemHandler)this.inputDisks, (int)4, (CompoundTag)tag);
        StackUtils.readItems((BaseItemHandler)this.outputDisks, (int)5, (CompoundTag)tag);
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)3, (CompoundTag)tag);
        StackUtils.writeItems((IItemHandler)this.inputDisks, (int)4, (CompoundTag)tag);
        StackUtils.writeItems((IItemHandler)this.outputDisks, (int)5, (CompoundTag)tag);
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)1, (CompoundTag)tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_MODE, this.mode);
        tag.m_128405_(NBT_TYPE, this.type);
        tag.m_128405_(NBT_IO_MODE, this.ioMode);
        return tag;
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)1, (CompoundTag)tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = tag.m_128451_(NBT_MODE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        if (tag.m_128441_(NBT_IO_MODE)) {
            this.ioMode = tag.m_128451_(NBT_IO_MODE);
        }
    }

    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputDisks, this.outputDisks, this.upgrades});
    }

    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }
}

