/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.node.diskmanipulator;

import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.ultramega.cabletiers.node.diskmanipulator.TieredDiskManipulatorNetworkNode;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class TieredStorageDiskFluidManipulatorWrapper
implements IStorageDisk<FluidStack> {
    private final TieredDiskManipulatorNetworkNode diskManipulator;
    private final IStorageDisk<FluidStack> parent;
    private DiskState lastState;

    public TieredStorageDiskFluidManipulatorWrapper(TieredDiskManipulatorNetworkNode diskManipulator, IStorageDisk<FluidStack> parent) {
        this.diskManipulator = diskManipulator;
        this.parent = parent;
        this.setSettings(() -> {
            DiskState currentState = DiskState.get((int)this.getStored(), (int)this.getCapacity());
            if (this.lastState != currentState) {
                this.lastState = currentState;
                LevelUtils.updateBlock((Level)diskManipulator.getLevel(), (BlockPos)diskManipulator.getPos());
            }
        }, diskManipulator);
        this.lastState = DiskState.get((int)this.getStored(), (int)this.getCapacity());
    }

    public int getCapacity() {
        return this.parent.getCapacity();
    }

    @Nullable
    public UUID getOwner() {
        return this.parent.getOwner();
    }

    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.parent.setSettings(listener, context);
    }

    public CompoundTag writeToNbt() {
        return this.parent.writeToNbt();
    }

    public ResourceLocation getFactoryId() {
        return this.parent.getFactoryId();
    }

    public Collection<FluidStack> getStacks() {
        return this.parent.getStacks();
    }

    @Nonnull
    public FluidStack insert(@Nonnull FluidStack stack, int size, Action action) {
        if (stack.isEmpty()) {
            return stack;
        }
        if (!IWhitelistBlacklist.acceptsFluid((FluidInventory)this.diskManipulator.getFluidFilters(), (int)this.diskManipulator.getWhitelistBlacklistMode(), (int)this.diskManipulator.getCompare(), (FluidStack)stack)) {
            return StackUtils.copy((FluidStack)stack, (int)size);
        }
        return (FluidStack)this.parent.insert((Object)stack, size, action);
    }

    @Nonnull
    public FluidStack extract(@Nonnull FluidStack stack, int size, int flags, Action action) {
        if (!IWhitelistBlacklist.acceptsFluid((FluidInventory)this.diskManipulator.getFluidFilters(), (int)this.diskManipulator.getWhitelistBlacklistMode(), (int)this.diskManipulator.getCompare(), (FluidStack)stack)) {
            return FluidStack.EMPTY;
        }
        return (FluidStack)this.parent.extract((Object)stack, size, flags, action);
    }

    public int getStored() {
        return this.parent.getStored();
    }

    public int getPriority() {
        return this.parent.getPriority();
    }

    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, (Object)remainder);
    }
}

