/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.packets;

import com.direwolf20.buildinggadgets2.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets2.common.network.PacketHandler;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketSendCopyData;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateTemplateManager {
    BlockPos blockPos;
    int mode;
    String templateName;

    public PacketUpdateTemplateManager(BlockPos blockPos, int mode, String templateName) {
        this.blockPos = blockPos;
        this.mode = mode;
        this.templateName = templateName;
    }

    public static PacketUpdateTemplateManager decode(FriendlyByteBuf buf) {
        return new PacketUpdateTemplateManager(buf.m_130135_(), buf.readInt(), buf.m_130277_());
    }

    public static void encode(PacketUpdateTemplateManager message, FriendlyByteBuf buf) {
        buf.m_130064_(message.blockPos);
        buf.writeInt(message.mode);
        buf.m_130070_(message.templateName);
    }

    public static void copyData(ServerPlayer sender, ItemStack sourceStack, ItemStack targetStack) {
        UUID sourceUUID = GadgetNBT.getUUID(sourceStack);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(sender.m_9236_().m_7654_()).m_129783_());
        ArrayList<StatePos> buildList = bg2Data.getCopyPasteList(sourceUUID, false);
        UUID targetUUID = GadgetNBT.getUUID(targetStack);
        GadgetNBT.setCopyUUID(targetStack);
        bg2Data.addToCopyPaste(targetUUID, buildList);
        CompoundTag tag = bg2Data.getCopyPasteListAsNBTMap(sourceUUID, false);
        PacketHandler.sendTo(new PacketSendCopyData(sourceUUID, GadgetNBT.getCopyUUID(sourceStack), tag), sender);
        tag = bg2Data.getCopyPasteListAsNBTMap(targetUUID, false);
        PacketHandler.sendTo(new PacketSendCopyData(targetUUID, GadgetNBT.getCopyUUID(targetStack), tag), sender);
    }

    public static void handle(PacketUpdateTemplateManager message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu container = sender.f_36096_;
            if (container == null || !(container instanceof TemplateManagerContainer)) {
                return;
            }
            ItemStack gadgetStack = container.m_38853_(0).m_7993_();
            ItemStack templateStack = container.m_38853_(1).m_7993_();
            if (message.mode == 0) {
                if (templateStack.m_41619_()) {
                    GadgetNBT.setTemplateName(gadgetStack, message.templateName);
                    return;
                }
                if (templateStack.m_150930_(Items.f_42516_)) {
                    container.m_182406_(1, container.m_182424_(), new ItemStack((ItemLike)Registration.Template.get()));
                    templateStack = container.m_38853_(1).m_7993_();
                }
                GadgetNBT.setTemplateName(templateStack, message.templateName);
                if (gadgetStack.m_41619_()) {
                    return;
                }
                PacketUpdateTemplateManager.copyData(sender, gadgetStack, templateStack);
            } else if (message.mode == 1) {
                if (templateStack.m_41619_() || gadgetStack.m_41619_()) {
                    return;
                }
                PacketUpdateTemplateManager.copyData(sender, templateStack, gadgetStack);
                GadgetNBT.setTemplateName(gadgetStack, GadgetNBT.getTemplateName(templateStack));
            }
        });
        context.get().setPacketHandled(true);
    }
}

