/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureChestUtil {
    private static final Map<String, ChestType> CHEST_TYPE_BY_ID = (Map)Util.m_137469_(new HashMap(), map -> {
        for (ChestType type : ChestType.values()) {
            map.put(type.m_7912_(), type);
        }
    });

    public static void createChest(BlockPos pos, ServerLevelAccessor level, RandomSource rand, Rotation rotation, Block block, Direction facing, ChestType chestType, ResourceLocation loot) {
        if (block instanceof ChestBlock) {
            level.m_7731_(pos, ((BlockState)((BlockState)block.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)chestType)).rotate((LevelAccessor)level, pos, rotation), 2);
            RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)rand, (BlockPos)pos, (ResourceLocation)loot);
        }
    }

    public static void createChest(BlockPos pos, ServerLevelAccessor level, RandomSource rand, Rotation rotation, String blockKey, String facingKey, String chestTypeKey, ResourceLocation loot) {
        StructureChestUtil.createChest(pos, level, rand, rotation, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockKey)), Direction.m_122402_((String)facingKey), StructureChestUtil.getChestType(chestTypeKey), loot);
    }

    public static void createChest(BlockPos pos, ServerLevelAccessor level, RandomSource rand, Rotation rotation, String blockKey, String facingKey, ResourceLocation loot) {
        StructureChestUtil.createChest(pos, level, rand, rotation, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockKey)), Direction.m_122402_((String)facingKey), ChestType.SINGLE, loot);
    }

    public static ChestType getChestType(String name) {
        return CHEST_TYPE_BY_ID.getOrDefault(name, ChestType.SINGLE);
    }
}

