/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.managers.AlchemyRecipeManager;
import com.legacy.blue_skies.data.managers.HorizoniteForgeFuelManager;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.managers.SkiesSyncedDataManager;
import com.legacy.blue_skies.data.managers.SnowcapMushroomFreezingManager;
import com.legacy.blue_skies.data.managers.SnowcapOvenFreezingManager;
import com.legacy.blue_skies.data.managers.ToolHandleTypeManager;
import com.legacy.blue_skies.data.managers.journal.JournalEntryManager;
import com.legacy.blue_skies.data.managers.journal.JournalRequirementManager;
import com.legacy.blue_skies.data.managers.journal.JournalSectionManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.AddReloadListenerEvent;

public class BlueSkiesData {
    public static final ToolHandleTypeManager TOOL_HANDLE_TYPES = new ToolHandleTypeManager();
    public static final SnowcapOvenFreezingManager SNOWCAP_OVEN_FREEZING = new SnowcapOvenFreezingManager();
    public static final HorizoniteForgeFuelManager HORIZONITE_FORGE_FUEL = new HorizoniteForgeFuelManager();
    public static final SnowcapMushroomFreezingManager SNOWCAP_MUSHROOM_FREEZING = new SnowcapMushroomFreezingManager();
    public static final AlchemyRecipeManager ALCHEMY_RECIPES = new AlchemyRecipeManager();
    public static final JournalEntryManager JOURNAL_ENTRIES = new JournalEntryManager();
    public static final JournalSectionManager JOURNAL_SECTIONS = new JournalSectionManager();
    public static final JournalRequirementManager JOURNAL_REQUIREMENTS = new JournalRequirementManager();
    public static final List<SkiesSyncedDataManager<?, ?, ?>> SYNCED_MANAGERS = new ArrayList();

    public static void addListeners(AddReloadListenerEvent event) {
        BlueSkiesData.register(event, TOOL_HANDLE_TYPES);
        BlueSkiesData.register(event, SNOWCAP_OVEN_FREEZING);
        BlueSkiesData.register(event, HORIZONITE_FORGE_FUEL);
        BlueSkiesData.register(event, SNOWCAP_MUSHROOM_FREEZING);
        BlueSkiesData.register(event, ALCHEMY_RECIPES);
        BlueSkiesData.register(event, JOURNAL_ENTRIES);
        BlueSkiesData.register(event, JOURNAL_SECTIONS);
        BlueSkiesData.register(event, JOURNAL_REQUIREMENTS);
    }

    public static void addSyncedListeners() {
        BlueSkiesData.registerSynced(TOOL_HANDLE_TYPES, SNOWCAP_OVEN_FREEZING, HORIZONITE_FORGE_FUEL, ALCHEMY_RECIPES);
        BlueSkiesData.registerSynced(JOURNAL_ENTRIES, JOURNAL_SECTIONS, JOURNAL_REQUIREMENTS);
    }

    private static void register(AddReloadListenerEvent event, SkiesDataManager<?, ?> dataManager) {
        event.addListener(dataManager);
    }

    private static void registerSynced(SkiesSyncedDataManager<?, ?, ?> ... managers) {
        for (SkiesSyncedDataManager<?, ?, ?> manager : managers) {
            SYNCED_MANAGERS.add(manager);
        }
    }

    public static void syncManagersToClient(ServerPlayer player) {
        SYNCED_MANAGERS.forEach(manager -> {
            BlueSkies.LOGGER.info("Sending {} to {}", (Object)manager.m_7812_(), (Object)player.m_7755_().getString());
            manager.syncToClient(player);
        });
    }

    public static SkiesSyncedDataManager<?, ?, ?> getSyncedManager(int id) {
        if (id >= 0 && id < SYNCED_MANAGERS.size()) {
            return SYNCED_MANAGERS.get(id);
        }
        BlueSkies.LOGGER.warn("Attempted to get a client-synced manager with an invalid id: {}", (Object)id);
        return TOOL_HANDLE_TYPES;
    }
}

