/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.entities.hostile.FrostSpiritEntity;
import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.items.tools.SkyPickaxeItem;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmoredFrostSpiritEntity
extends SkiesMonsterEntity {
    public static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(ArmoredFrostSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ArmoredFrostSpiritEntity(EntityType<? extends ArmoredFrostSpiritEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{ZombifiedPiglin.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.17f).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)0);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.determineTypeByDifficulty();
        float f = difficulty.m_19057_();
        this.m_21553_(this.f_19796_.m_188501_() < 0.55f * f);
        this.m_21051_(Attributes.f_22278_).m_22125_(new AttributeModifier("Random spawn bonus", this.f_19796_.m_188500_() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        if (this.getIceType() == 1) {
            this.m_21051_(Attributes.f_22284_).m_22125_(new AttributeModifier("armor boost", 8.0, AttributeModifier.Operation.ADDITION));
        }
        if (this.m_9236_().m_46471_()) {
            double armorAmount = this.getIceType() == 1 ? 3.0 : 7.0;
            this.m_21051_(Attributes.f_22284_).m_22125_(new AttributeModifier("weather armor boost", armorAmount, AttributeModifier.Operation.ADDITION));
            if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("speed boost", 0.04, AttributeModifier.Operation.ADDITION));
                this.m_21051_(Attributes.f_22281_).m_22125_(new AttributeModifier("attack nerf", -1.0, AttributeModifier.Operation.ADDITION));
            }
        }
        return spawnDataIn;
    }

    public void setIceType(int type) {
        this.f_19804_.m_135381_(TYPE, (Object)type);
    }

    public int getIceType() {
        return (Integer)this.f_19804_.m_135370_(TYPE);
    }

    @Override
    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.0f;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        boolean randomBoolean = this.m_9236_().m_46471_() ? true : this.f_19796_.m_188499_();
        return randomBoolean && super.m_5545_(worldIn, spawnReasonIn);
    }

    public boolean m_6469_(DamageSource ds, float amount) {
        if (ds.m_269533_(DamageTypeTags.f_268745_) || ds.m_269533_(DamageTypeTags.f_268581_)) {
            if (ds.m_269533_(DamageTypeTags.f_268745_) && this.f_20916_ <= 0) {
                this.m_5496_(SoundEvents.f_11914_, 0.3f, 1.0f);
            } else {
                this.m_5496_(SoundEvents.f_12540_, 0.8f, 1.0f);
            }
            if (this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 1.5, this.m_20189_(), 20, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
            }
            return super.m_6469_(ds, amount * 2.0f);
        }
        if (ds.m_7639_() instanceof LivingEntity && this.f_20916_ <= 0) {
            Player player;
            ItemStack stack;
            if (this.m_9236_() instanceof ServerLevel) {
                for (int i = 0; i < 2; ++i) {
                    if (this.getIceType() == 1) {
                        this.spawnBlockParticles(Blocks.f_50354_.m_49966_(), 20);
                        continue;
                    }
                    this.spawnBlockParticles(Blocks.f_50126_.m_49966_(), 20);
                }
            }
            if (!this.m_20067_()) {
                this.m_5496_(SoundEvents.f_11983_, 0.5f, 1.0f);
            }
            if (ds.m_7640_() instanceof Player && (stack = (player = (Player)ds.m_7640_()).m_150109_().m_36056_()).m_41720_() instanceof SkyPickaxeItem) {
                return super.m_6469_(ds, amount * 2.0f);
            }
        }
        return super.m_6469_(ds, amount);
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_ARMORED_FROST_SPIRIT_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_ARMORED_FROST_SPIRIT_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_ARMORED_FROST_SPIRIT_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public int m_8100_() {
        return 120;
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f + 1.0f;
    }

    public void determineTypeByDifficulty() {
        switch (this.m_9236_().m_46791_()) {
            case EASY: {
                this.setIceType(this.f_19796_.m_188503_(4) == 0 ? 1 : 0);
                break;
            }
            case NORMAL: {
                this.setIceType(this.f_19796_.m_188503_(2));
                break;
            }
            case HARD: {
                this.setIceType(this.f_19796_.m_188503_(4) == 0 ? 0 : 1);
                break;
            }
        }
    }

    public static Item getSkyArmorByChance(EquipmentSlot slotIn, int chance) {
        switch (slotIn) {
            case HEAD: {
                switch (chance) {
                    case 0: {
                        return Items.f_42407_;
                    }
                    case 1: {
                        return SkiesItems.pyrope_helmet;
                    }
                    case 2: {
                        return SkiesItems.aquite_helmet;
                    }
                    case 3: {
                        return SkiesItems.diopside_helmet;
                    }
                    case 4: {
                        return SkiesItems.charoite_helmet;
                    }
                }
                return null;
            }
            case CHEST: {
                switch (chance) {
                    case 0: {
                        return Items.f_42408_;
                    }
                    case 1: {
                        return SkiesItems.pyrope_chestplate;
                    }
                    case 2: {
                        return SkiesItems.aquite_chestplate;
                    }
                    case 3: {
                        return SkiesItems.diopside_chestplate;
                    }
                    case 4: {
                        return SkiesItems.charoite_chestplate;
                    }
                }
                return null;
            }
            case LEGS: {
                switch (chance) {
                    case 0: {
                        return Items.f_42462_;
                    }
                    case 1: {
                        return SkiesItems.pyrope_leggings;
                    }
                    case 2: {
                        return SkiesItems.aquite_leggings;
                    }
                    case 3: {
                        return SkiesItems.diopside_leggings;
                    }
                    case 4: {
                        return SkiesItems.charoite_leggings;
                    }
                }
                return null;
            }
            case FEET: {
                switch (chance) {
                    case 0: {
                        return Items.f_42463_;
                    }
                    case 1: {
                        return SkiesItems.pyrope_boots;
                    }
                    case 2: {
                        return SkiesItems.aquite_boots;
                    }
                    case 3: {
                        return SkiesItems.diopside_boots;
                    }
                    case 4: {
                        return SkiesItems.charoite_boots;
                    }
                }
                return null;
            }
        }
        return null;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        int i;
        if (random.m_188501_() < 0.15f * difficulty.m_19057_()) {
            float f;
            i = random.m_188503_(2);
            float f2 = f = this.m_9236_().m_46791_() == Difficulty.HARD ? 0.1f : 0.25f;
            if (random.m_188501_() < 0.095f) {
                ++i;
            }
            if (random.m_188501_() < 0.095f) {
                ++i;
            }
            if (random.m_188501_() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlot entityequipmentslot : EquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.m_6844_(entityequipmentslot);
                if (!flag && random.m_188501_() < f) break;
                flag = false;
                if (!itemstack.m_41619_() || (item = ArmoredFrostSpiritEntity.getSkyArmorByChance(entityequipmentslot, i)) == null) continue;
                this.m_8061_(entityequipmentslot, new ItemStack((ItemLike)item));
            }
        }
        float f = random.m_188501_();
        float f3 = this.m_9236_().m_46791_() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f3) {
            i = random.m_188503_(3);
            if (i == 0) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SkiesItems.aquite_sword));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SkiesItems.pyrope_sword));
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("IceType", this.getIceType());
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setIceType(compound.m_128451_("IceType"));
    }

    public float m_20236_(Pose pose) {
        float f = 1.74f;
        if (this.m_6162_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    protected void m_8024_() {
        if (this.f_19797_ % 20 == 0) {
            if (this.m_20072_()) {
                this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
            } else if (this.m_20070_() && this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 1.5, this.m_20189_(), 20, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
            }
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().f_46443_) {
            Vec3 pos = this.m_20182_().m_82520_(0.0, 1.5, 0.0);
            FrostSpiritEntity spirit = (FrostSpiritEntity)SkiesEntityTypes.FROST_SPIRIT.m_20615_(this.m_9236_());
            spirit.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, this.f_19859_, this.f_19860_);
            spirit.m_20334_(0.0, 1.0, 0.0);
            spirit.m_20225_(this.m_20067_());
            spirit.m_6593_(this.m_7770_());
            spirit.m_20340_(this.m_20151_());
            this.m_9236_().m_7967_((Entity)spirit);
            this.m_21373_();
            this.m_146870_();
            spirit.m_5496_(SkiesSounds.ENTITY_FROST_SPIRIT_FREE, spirit.m_6121_(), super.m_6100_());
        }
    }

    public int m_5792_() {
        return 1;
    }

    public ResourceLocation m_7582_() {
        if (this.getIceType() == 1) {
            return BlueSkies.locate("entities/" + ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_()).m_135815_() + "_packed");
        }
        return this.m_6095_().m_20677_();
    }
}

