/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.capability;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.dungeon.KeystoneBlock;
import com.legacy.blue_skies.capability.ArcInventory;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.entities.SupporterPetEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.items.arcs.IArcItem;
import com.legacy.blue_skies.items.tools.weapons.AlchemyScrollItem;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.DisplayToastPacket;
import com.legacy.blue_skies.network.s_to_c.DungeonMusicPacket;
import com.legacy.blue_skies.network.s_to_c.SyncPlayerPacket;
import com.legacy.blue_skies.network.s_to_c.UpdateBlueLorePacket;
import com.legacy.blue_skies.network.s_to_c.UpdateNatureHealthPacket;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class SkiesPlayer
implements ISkiesPlayer {
    public static final Capability<ISkiesPlayer> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISkiesPlayer>(){});
    private static final Marker MARKER = MarkerManager.getMarker((String)"Player Capability");
    private Player player;
    private SkiesDungeonType activeBossType;
    private ArcInventory arcInventory;
    public SkiesDungeonType dungeonMusicType;
    private boolean wasInStructure = false;
    private boolean supporterPetEnabled = false;
    private boolean supporterPetAudible = false;
    private boolean usedBlueLore = false;
    private boolean openedBlueLore = false;
    private boolean fullDuskInvis = false;
    private byte brightProgression = 0;
    private byte dawnProgression = 0;
    private byte supporterPetId = 0;
    private byte supporterStyleId = 0;
    private float natureHealth;
    private Vec3 preservedMotionVec;
    private LivingEntity supporterPet;
    private String supporterPetName = "";
    private BlockPos prevKeystonePos = null;

    public SkiesPlayer() {
    }

    public SkiesPlayer(Player player) {
        this.player = player;
        this.arcInventory = new ArcInventory();
        this.arcInventory.refreshArcs(player);
    }

    @Override
    public Capability<ISkiesPlayer> getDefaultInstance() {
        return INSTANCE;
    }

    @Nullable
    public static ISkiesPlayer get(Player player) {
        return SkiesPlayer.getIfPresent(player, skyPlayer -> skyPlayer, () -> null);
    }

    public static <E extends Player> void ifPresent(E player, Consumer<ISkiesPlayer> action) {
        Optional optional;
        if (player != null && !(player instanceof FakePlayer) && (optional = player.getCapability(INSTANCE).resolve()).isPresent()) {
            action.accept((ISkiesPlayer)optional.get());
        }
    }

    public static <E extends Player, R> R getIfPresent(E player, Function<ISkiesPlayer, R> action, Supplier<R> elseSupplier) {
        Optional optional;
        if (player != null && !(player instanceof FakePlayer) && (optional = player.getCapability(INSTANCE).resolve()).isPresent()) {
            return action.apply((ISkiesPlayer)optional.get());
        }
        return elseSupplier.get();
    }

    @Override
    public void serverTick() {
        if (this.player != null && this.player instanceof ServerPlayer && !this.player.m_20193_().m_5776_()) {
            this.getArcInventory().getStacks().forEach(stack -> {
                if (stack.m_41720_() instanceof IArcItem) {
                    ((IArcItem)stack.m_41720_()).serverTick((ItemStack)stack, (ServerPlayer)this.player);
                }
            });
            this.updateDungeonMusic();
            if (!this.player.m_7500_() && !this.player.m_5833_() && this.player.f_19797_ % 40 == 0 && (this.getBrightProgression() < 1 && EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.NATURE_DUNGEON.getStructure()) || this.getDawnProgression() < 1 && this.player.m_20183_().m_123342_() < 63 && EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.POISON_DUNGEON.getStructure()))) {
                this.player.m_5661_((Component)Component.m_237115_((String)"gui.blue_skies.tooltip.not_progressed"), true);
                this.player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80));
                this.player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 1));
                this.player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 50, 1));
            }
            if (BlueSkies.ML_SUPPORTER.getRank(this.player).hasPerks()) {
                if (this.isSupporterPetEnabled()) {
                    this.checkAndSpawnPet();
                    if (this.getSupporterPet() != null && !this.getSupporterPet().m_9236_().m_46472_().m_135782_().equals((Object)this.player.m_9236_().m_46472_().m_135782_())) {
                        this.getSupporterPet().m_146870_();
                        this.setSupporterPet(null);
                    }
                } else if (this.getSupporterPet() != null) {
                    this.getSupporterPet().m_146870_();
                    this.setSupporterPet(null);
                }
            }
            if (this.player.m_21211_().m_41720_() instanceof AlchemyScrollItem && this.player.f_19797_ % 5 == 0) {
                AlchemyScrollItem.beginSpikeSpawning(this.player, false, 8);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        if (this.player != null && this.player instanceof LocalPlayer && this.player.m_20193_().m_5776_()) {
            this.getArcInventory().getStacks().forEach(stack -> {
                if (stack.m_41720_() instanceof IArcItem) {
                    ((IArcItem)stack.m_41720_()).clientTick((ItemStack)stack, (LocalPlayer)this.player);
                }
            });
        }
    }

    @Override
    public CompoundTag writeAdditional(CompoundTag compound) {
        compound.m_128365_("ArcInventory", (Tag)this.arcInventory.write(new ListTag()));
        compound.m_128344_("EverbrightProgression", this.getBrightProgression());
        compound.m_128344_("EverdawnProgression", this.getDawnProgression());
        compound.m_128344_("SupporterPetID", this.getSupporterPetID());
        compound.m_128379_("SupporterPetEnabled", this.isSupporterPetEnabled());
        compound.m_128379_("SupporterPetAudible", this.isSupporterPetAudible());
        compound.m_128344_("SupporterStyleID", this.getSupporterStyleID());
        compound.m_128379_("UsedBlueLore", this.hasUsedBlueLore());
        compound.m_128379_("OpenedBlueLore", this.hasOpenedBlueLore());
        compound.m_128379_("FullDuskInvis", this.hasFullDuskInvis());
        compound.m_128350_("NatureHealth", this.getNatureHealth());
        if (this.prevKeystonePos != null) {
            compound.m_128365_("KeystoneTeleportPos", (Tag)NbtUtils.m_129224_((BlockPos)this.prevKeystonePos));
        }
        if (this.getSupporterPetName().length() > 1) {
            compound.m_128359_("SupporterPetName", this.getSupporterPetName());
        }
        return compound;
    }

    @Override
    public void read(CompoundTag compound) {
        this.arcInventory.read(compound.m_128437_("ArcInventory", 10));
        this.setBrightProgression(compound.m_128445_("EverbrightProgression"));
        this.setDawnProgression(compound.m_128445_("EverdawnProgression"));
        this.setSupporterPetID(compound.m_128445_("SupporterPetID"));
        this.setSupporterPetEnabled(compound.m_128471_("SupporterPetEnabled"));
        this.setSupporterPetAudible(compound.m_128471_("SupporterPetAudible"));
        this.setSupporterStyleID(compound.m_128445_("SupporterStyleID"));
        this.setUsedBlueLore(compound.m_128471_("UsedBlueLore"));
        this.setOpenedBlueLore(compound.m_128471_("OpenedBlueLore"));
        this.setFullDuskInvis(compound.m_128471_("FullDuskInvis"));
        this.setNatureHealth(compound.m_128457_("NatureHealth"));
        this.prevKeystonePos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("KeystoneTeleportPos"));
        if (compound.m_128461_("SupporterPetName").length() > 1) {
            this.setSupporterPetName(compound.m_128461_("SupporterPetName"));
        }
    }

    @Override
    public void syncDataToClient() {
        if (this.getPlayer() instanceof ServerPlayer) {
            PacketHandler.sendToClient(new SyncPlayerPacket(this.writeAdditional(new CompoundTag())), (ServerPlayer)this.getPlayer());
        }
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void setBossType(SkiesDungeonType bossType) {
        this.activeBossType = bossType;
    }

    @Override
    public SkiesDungeonType getBossType() {
        return this.activeBossType;
    }

    @Override
    public void setDungeonMusicId(SkiesDungeonType musicType) {
        this.dungeonMusicType = musicType;
    }

    @Override
    public SkiesDungeonType getDungeonMusicId() {
        return this.dungeonMusicType;
    }

    @Override
    public ArcInventory getArcInventory() {
        return this.arcInventory;
    }

    @Override
    public void onDeath() {
        if (!this.player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            for (int i = 0; i < this.arcInventory.m_6643_(); ++i) {
                ItemStack stack = this.arcInventory.m_8020_(i);
                if (stack.m_41619_()) continue;
                if (EnchantmentHelper.m_44924_((ItemStack)stack)) {
                    this.arcInventory.m_8016_(i);
                    continue;
                }
                this.player.m_7197_(stack.m_41777_(), true, false);
                this.arcInventory.m_8020_(i);
            }
        }
        this.syncDataToClient();
        this.player.m_9236_().m_6443_(Mob.class, this.player.m_20191_().m_82400_(30.0), ISkyBoss.IS_BOSS).forEach(boss -> {
            boolean playersAlive;
            List players = this.player.m_9236_().m_6443_(Player.class, this.player.m_20191_().m_82400_(30.0), entity -> entity.m_6084_() && entity.m_21223_() > 0.0f && !entity.m_7500_() && !entity.m_5833_());
            boolean bl = playersAlive = players.size() > 0;
            if (playersAlive) {
                boss.m_5634_(((ISkyBoss)boss).getHealAmount());
            } else if (this.player.m_9236_().m_46791_() == Difficulty.EASY) {
                boss.m_5634_(((ISkyBoss)boss).getHealAmount() * 1.5f);
            } else {
                boss.m_5634_(boss.m_21233_());
            }
        });
    }

    private void updateDungeonMusic() {
        boolean inDungeon;
        boolean bl = inDungeon = EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.NATURE_DUNGEON.getStructure()) || EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.POISON_DUNGEON.getStructure()) || EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()) || EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure());
        if (this.wasInStructure != inDungeon) {
            SkiesDungeonType dungeonType = EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON.getStructure()) || EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.EVERDAWN_BLINDING_DUNGEON.getStructure()) ? SkiesDungeonType.BLINDING : (EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.NATURE_DUNGEON.getStructure()) ? SkiesDungeonType.NATURE : (EntityUtil.isPosInStructure(this.player.m_9236_(), this.player.m_20183_(), (Registrar.Pointer<Structure>)SkiesStructures.POISON_DUNGEON.getStructure()) ? SkiesDungeonType.POISON : SkiesDungeonType.NONE));
            PacketHandler.sendToClient(new DungeonMusicPacket((byte)dungeonType.getId()), (ServerPlayer)this.player);
            this.wasInStructure = inDungeon;
        }
    }

    @Override
    public void teleportToNearestKeystone() {
        if (!(this.player.m_9236_() instanceof ServerLevel)) {
            return;
        }
        BlockPos playerPos = this.player.m_20183_();
        int distance = 30;
        ServerLevel world = (ServerLevel)this.player.m_9236_();
        PoiManager pointofinterestmanager = world.m_8904_();
        pointofinterestmanager.m_27056_((LevelReader)this.player.m_9236_(), playerPos, distance);
        Optional optional = world.m_8904_().m_27166_(poiType -> poiType.m_203565_(SkiesPoiTypes.KEYSTONE.getKey()), playerPos, distance, PoiManager.Occupancy.ANY).findFirst();
        if (optional.isPresent()) {
            BlockState keystoneState = world.m_8055_(((PoiRecord)optional.get()).m_27257_());
            BlockPos spawnPos = keystoneState.m_61138_(KeystoneBlock.DirectionalKeystoneBlock.FACING) ? ((PoiRecord)optional.get()).m_27257_().m_5484_((Direction)keystoneState.m_61143_(KeystoneBlock.DirectionalKeystoneBlock.FACING), 2) : ((PoiRecord)optional.get()).m_27257_().m_5484_(Direction.NORTH, 3);
            this.player.m_6034_((double)((float)spawnPos.m_123341_() + 0.5f), (double)spawnPos.m_123342_(), (double)((float)spawnPos.m_123343_() + 0.5f));
            if (this.player instanceof ServerPlayer) {
                PacketHandler.sendToClient(new DisplayToastPacket(1), (ServerPlayer)this.player);
            }
        }
    }

    @Override
    public void checkAndSpawnPet() {
        if (this.isSupporterPetEnabled() && this.getSupporterPet() == null && BlueSkies.ML_SUPPORTER.getRank(this.player).hasPerks()) {
            try {
                SupporterPetEntity pet = SkiesPlayer.createPet(this.player.m_9236_());
                pet.m_7105_(true);
                pet.m_21816_(this.player.m_20148_());
                this.setSupporterPet((LivingEntity)pet);
                pet.setTypeID((byte)Math.max(0, this.getSupporterPetID()));
                pet.m_6034_(this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_());
                pet.m_20225_(!this.isSupporterPetAudible());
                if (this.getSupporterPetName() != null && !pet.m_8077_() && this.getSupporterPetName().length() > 0) {
                    pet.m_20340_(true);
                    pet.m_6593_((Component)Component.m_237113_((String)this.getSupporterPetName()).m_130940_(ChatFormatting.values()[Math.max(0, this.supporterStyleId)]));
                }
                this.player.m_9236_().m_7967_((Entity)pet);
            }
            catch (NullPointerException e) {
                BlueSkies.LOGGER.error(MARKER, "Something went wrong trying to spawn a supporter pet for {}!", (Object)this.player.m_7755_().getString(), (Object)e);
            }
        }
    }

    private static SupporterPetEntity createPet(Level level) {
        return Objects.requireNonNull((SupporterPetEntity)SkiesEntityTypes.SUPPORTER_PET.m_20615_(level));
    }

    @Override
    public byte getBrightProgression() {
        return this.brightProgression;
    }

    @Override
    public byte getDawnProgression() {
        return this.dawnProgression;
    }

    @Override
    public byte getSupporterPetID() {
        return this.supporterPetId;
    }

    @Override
    public Vec3 getSavedClientMotion() {
        return this.preservedMotionVec;
    }

    @Override
    public LivingEntity getSupporterPet() {
        return this.supporterPet;
    }

    @Override
    public boolean isSupporterPetEnabled() {
        return this.supporterPetEnabled;
    }

    @Override
    public boolean isSupporterPetAudible() {
        return this.supporterPetAudible;
    }

    @Override
    public String getSupporterPetName() {
        return this.supporterPetName;
    }

    @Override
    public boolean hasUsedBlueLore() {
        return this.usedBlueLore;
    }

    @Override
    public boolean hasOpenedBlueLore() {
        return this.openedBlueLore;
    }

    @Override
    public void setBrightProgression(byte bossNumber) {
        this.brightProgression = bossNumber;
    }

    @Override
    public void setDawnProgression(byte bossNumber) {
        this.dawnProgression = bossNumber;
    }

    @Override
    public void setSavedClientMotion(double motionX, double motionY, double motionZ) {
        this.preservedMotionVec = new Vec3(motionX, 0.0, motionZ);
    }

    @Override
    public void setSupporterPetID(byte id) {
        this.supporterPetId = id;
    }

    @Override
    public void setSupporterPetEnabled(boolean enabled) {
        this.supporterPetEnabled = enabled;
    }

    @Override
    public void setSupporterPetAudible(boolean audible) {
        this.supporterPetAudible = audible;
    }

    @Override
    public void setSupporterPetName(String name) {
        this.supporterPetName = name;
    }

    @Override
    public void setSupporterPet(LivingEntity entity) {
        this.supporterPet = entity;
    }

    @Override
    public byte getSupporterStyleID() {
        return this.supporterStyleId;
    }

    @Override
    public void setSupporterStyleID(byte id) {
        this.supporterStyleId = id;
    }

    @Override
    public void setUsedBlueLore(boolean used) {
        this.usedBlueLore = used;
        if (this.getPlayer() != null && this.getPlayer() instanceof ServerPlayer) {
            PacketHandler.sendToClient(new UpdateBlueLorePacket(used), (ServerPlayer)this.getPlayer());
        }
    }

    @Override
    public void setOpenedBlueLore(boolean opened) {
        this.openedBlueLore = opened;
    }

    @Override
    public boolean hasFullDuskInvis() {
        return this.fullDuskInvis;
    }

    @Override
    public void setFullDuskInvis(boolean isInvisible) {
        this.fullDuskInvis = isInvisible;
    }

    @Override
    public float getNatureHealth() {
        return this.natureHealth;
    }

    @Override
    public void setNatureHealth(float value) {
        if (Float.isNaN(value)) {
            value = 0.0f;
        }
        this.natureHealth = Mth.m_14036_((float)value, (float)0.0f, (float)20.0f);
        if (this.getPlayer() != null && this.getPlayer() instanceof ServerPlayer) {
            PacketHandler.sendToClient(new UpdateNatureHealthPacket(value), (ServerPlayer)this.getPlayer());
        }
    }
}

