/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="zephyr")
public class RitualZephyr
extends Ritual {
    public static final String ZEPHYR_RANGE = "zephyrRange";
    public static final String CHEST_RANGE = "chest";

    public RitualZephyr() {
        super("ritualZephyr", 0, 1000, "ritual.bloodmagic.zephyrRitual");
        this.addBlockRange(ZEPHYR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -5, -5), 11));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(ZEPHYR_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        BlockEntity tileInventory = world.m_7702_(chestRange.getContainedPositions(masterPos).get(0));
        if (!masterRitualStone.getWorldObj().f_46443_ && tileInventory != null) {
            if (currentEssence < this.getRefreshCost()) {
                masterRitualStone.getOwnerNetwork().causeNausea();
                return;
            }
            AreaDescriptor zephyrRange = masterRitualStone.getBlockRange(ZEPHYR_RANGE);
            List itemList = world.m_45976_(ItemEntity.class, zephyrRange.getAABB(masterRitualStone.getMasterBlockPos()));
            int count = 0;
            for (ItemEntity entityItem : itemList) {
                if (!entityItem.m_6084_()) continue;
                ItemStack copyStack = entityItem.m_32055_().m_41777_();
                int originalAmount = copyStack.m_41613_();
                ItemStack newStack = Utils.insertStackIntoTile(copyStack, tileInventory, Direction.DOWN);
                if (!newStack.m_41619_() && newStack.m_41613_() < originalAmount) {
                    ++count;
                    if (newStack.m_41619_()) {
                        entityItem.m_142687_(Entity.RemovalReason.KILLED);
                    }
                    entityItem.m_32055_().m_41764_(newStack.m_41613_());
                }
                if (!newStack.m_41619_()) continue;
                entityItem.m_142687_(Entity.RemovalReason.KILLED);
            }
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * Math.min(count, 100)));
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 2, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 1, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, -1, EnumRuneType.AIR);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualZephyr();
    }
}

