/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="water")
public class RitualWater
extends Ritual {
    public static final String WATER_RANGE = "waterRange";
    public static final String WATER_TANK_RANGE = "waterTank";

    public RitualWater() {
        super("ritualWater", 0, 500, "ritual.bloodmagic.waterRitual");
        this.addBlockRange(WATER_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.addBlockRange(WATER_TANK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(WATER_RANGE, 9, 3, 3);
        this.setMaximumVolumeAndDistanceOfRange(WATER_TANK_RANGE, 1, 10, 10);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        int lpDrain = 0;
        AreaDescriptor waterRange = masterRitualStone.getBlockRange(WATER_RANGE);
        for (BlockPos newPos : waterRange.getContainedPositions(masterRitualStone.getMasterBlockPos())) {
            if (world.m_46859_(newPos)) {
                world.m_46597_(newPos, Blocks.f_49990_.m_49966_());
                ++totalEffects;
            }
            if (totalEffects < maxEffects) continue;
            break;
        }
        lpDrain += this.getRefreshCost() * totalEffects;
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double rawDrained = 0.0;
        if (rawWill > 0.0) {
            LazyOptional capability;
            AreaDescriptor chestRange = masterRitualStone.getBlockRange(WATER_TANK_RANGE);
            BlockEntity tile = world.m_7702_(chestRange.getContainedPositions(pos).get(0));
            double drain = this.getWillCostForRawWill(rawWill);
            int lpCost = this.getLPCostForRawWill(rawWill);
            if (rawWill >= drain && currentEssence >= lpCost && tile != null && (capability = tile.getCapability(ForgeCapabilities.FLUID_HANDLER, null)).isPresent()) {
                IFluidHandler handler = (IFluidHandler)capability.resolve().get();
                double filled = handler.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                double ratio = filled / 1000.0;
                rawWill -= drain * ratio;
                rawDrained += drain * ratio;
                currentEssence = (int)((double)currentEssence - Math.ceil((double)lpCost * ratio));
                lpDrain = (int)((double)lpDrain + Math.ceil((double)lpCost * ratio));
            }
        }
        if (rawDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrained, true);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(lpDrain));
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 25;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.WATER);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualWater();
    }

    public int getLPCostForRawWill(double raw) {
        return Math.max((int)(20.0 - raw / 10.0), 0);
    }

    public double getWillCostForRawWill(double raw) {
        return Math.min(1.0, raw / 1000.0);
    }
}

