/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.BloodMagicRecipe;

public class RecipeBloodAltar
extends BloodMagicRecipe {
    @Nonnull
    private final Ingredient input;
    @Nonnull
    private final ItemStack output;
    @Nonnull
    private final int minimumTier;
    @Nonnegative
    private final int syphon;
    @Nonnegative
    private final int consumeRate;
    @Nonnegative
    private final int drainRate;

    public RecipeBloodAltar(ResourceLocation id, @Nonnull Ingredient input, @Nonnull ItemStack output, @Nonnegative int minimumTier, @Nonnegative int syphon, @Nonnegative int consumeRate, @Nonnegative int drainRate) {
        super(id);
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((minimumTier >= 0 ? 1 : 0) != 0, (Object)"minimumTier cannot be negative.");
        Preconditions.checkArgument((minimumTier <= 6 ? 1 : 0) != 0, (Object)"minimumTier cannot be higher than max tier");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((consumeRate >= 0 ? 1 : 0) != 0, (Object)"consumeRate cannot be negative.");
        Preconditions.checkArgument((drainRate >= 0 ? 1 : 0) != 0, (Object)"drain cannot be negative.");
        this.input = input;
        this.output = output;
        this.minimumTier = minimumTier;
        this.syphon = syphon;
        this.consumeRate = consumeRate;
        this.drainRate = drainRate;
    }

    @Nonnull
    public final Ingredient getInput() {
        return this.input;
    }

    public final NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.getInput());
        return list;
    }

    @Nonnull
    public final ItemStack getOutput() {
        return this.output;
    }

    public int getMinimumTier() {
        return this.minimumTier;
    }

    @Nonnegative
    public final int getSyphon() {
        return this.syphon;
    }

    @Nonnegative
    public final int getConsumeRate() {
        return this.consumeRate;
    }

    @Nonnegative
    public final int getDrainRate() {
        return this.drainRate;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        buffer.m_130055_(this.output);
        buffer.writeInt(this.minimumTier);
        buffer.writeInt(this.syphon);
        buffer.writeInt(this.consumeRate);
        buffer.writeInt(this.drainRate);
    }

    public RecipeSerializer<RecipeBloodAltar> m_7707_() {
        return BloodMagicRecipeSerializers.ALTAR.getRecipeSerializer();
    }

    public RecipeType<RecipeBloodAltar> m_6671_() {
        return (RecipeType)BloodMagicRecipeType.ALTAR.get();
    }
}

