/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.registration.impl.LivingUpgradeDeferredRegister;
import wayoftime.bloodmagic.common.registration.impl.LivingUpgradeRegistryObject;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.gson.Serializers;
import wayoftime.bloodmagic.util.Utils;

public class LivingArmorRegistrar {
    public static final LivingUpgradeDeferredRegister UPGRADES = new LivingUpgradeDeferredRegister("bloodmagic");
    public static final Map<ResourceLocation, LivingUpgrade> UPGRADE_MAP = new HashMap<ResourceLocation, LivingUpgrade>();
    private static final Map<String, ResourceLocation> DEFINITIONS = ((Supplier<Map>)() -> {
        HashMap<String, ResourceLocation> def = new HashMap<String, ResourceLocation>();
        def.put("arrow_protect", BloodMagic.rl("arrow_protect"));
        def.put("arrow_shot", BloodMagic.rl("arrow_shot"));
        def.put("critical_strike", BloodMagic.rl("critical_strike"));
        def.put("digging", BloodMagic.rl("digging"));
        def.put("experienced", BloodMagic.rl("experienced"));
        def.put("fall_protect", BloodMagic.rl("fall_protect"));
        def.put("fire_resist", BloodMagic.rl("fire_resist"));
        def.put("grave_digger", BloodMagic.rl("grave_digger"));
        def.put("health", BloodMagic.rl("health"));
        def.put("jump", BloodMagic.rl("jump"));
        def.put("knockback_resist", BloodMagic.rl("knockback_resist"));
        def.put("melee_damage", BloodMagic.rl("melee_damage"));
        def.put("physical_protect", BloodMagic.rl("physical_protect"));
        def.put("poison_resist", BloodMagic.rl("poison_resist"));
        def.put("sprint_attack", BloodMagic.rl("sprint_attack"));
        def.put("speed", BloodMagic.rl("speed"));
        def.put("self_sacrifice", BloodMagic.rl("self_sacrifice"));
        def.put("elytra", BloodMagic.rl("elytra"));
        def.put("curios_socket", BloodMagic.rl("curios_socket"));
        def.put("diamond_protect", BloodMagic.rl("diamond_protect"));
        def.put("repair", BloodMagic.rl("repair"));
        def.put("downgrade/quenched", BloodMagic.rl("downgrade/quenched"));
        def.put("downgrade/storm_trooper", BloodMagic.rl("downgrade/storm_trooper"));
        def.put("downgrade/battle_hungry", BloodMagic.rl("downgrade/battle_hungry"));
        def.put("downgrade/melee_decrease", BloodMagic.rl("downgrade/melee_decrease"));
        def.put("downgrade/dig_slowdown", BloodMagic.rl("downgrade/dig_slowdown"));
        def.put("downgrade/slow_heal", BloodMagic.rl("downgrade/slow_heal"));
        def.put("downgrade/crippled_arm", BloodMagic.rl("downgrade/crippled_arm"));
        def.put("downgrade/swim_decrease", BloodMagic.rl("downgrade/swim_decrease"));
        def.put("downgrade/speed_decrease", BloodMagic.rl("downgrade/speed_decrease"));
        return def;
    }).get();
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_ARROW_PROTECT = UPGRADES.register("arrow_protect", () -> LivingArmorRegistrar.parseDefinition("arrow_protect").withArmorProvider((player, stats, source, upgrade, level) -> {
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            return upgrade.getBonusValue("protection", level).doubleValue();
        }
        return 0.0;
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_FALL_PROTECT = UPGRADES.register("fall_protect", () -> LivingArmorRegistrar.parseDefinition("fall_protect").withArmorProvider((player, stats, source, upgrade, level) -> {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return upgrade.getBonusValue("protection", level).doubleValue();
        }
        return 0.0;
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_PHYSICAL_PROTECT = UPGRADES.register("physical_protect", () -> LivingArmorRegistrar.parseDefinition("physical_protect").withArmorProvider((player, stats, source, upgrade, level) -> {
        if (Utils.isMeleeDamage(source)) {
            return upgrade.getBonusValue("protection", level).doubleValue();
        }
        return 0.0;
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_JUMP = UPGRADES.register("jump", () -> LivingArmorRegistrar.parseDefinition("jump"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_HEALTH = UPGRADES.register("health", () -> LivingArmorRegistrar.parseDefinition("health").withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> attributeMap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(uuid, "Health Modifier", (double)upgrade.getBonusValue("hp", level).intValue(), AttributeModifier.Operation.ADDITION))));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_EXPERIENCE = UPGRADES.register("experienced", () -> LivingArmorRegistrar.parseDefinition("experienced"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_SPRINT_ATTACK = UPGRADES.register("sprint_attack", () -> LivingArmorRegistrar.parseDefinition("sprint_attack").withDamageProvider((player, weapon, damage, stats, attackedEntity, upgrade, level) -> {
        if (player.m_20142_()) {
            return damage * upgrade.getBonusValue("damage_boost", level).doubleValue();
        }
        return 0.0;
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_SELF_SACRIFICE = UPGRADES.register("self_sacrifice", () -> LivingArmorRegistrar.parseDefinition("self_sacrifice"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_SPEED = UPGRADES.register("speed", () -> LivingArmorRegistrar.parseDefinition("speed").withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> attributeMap.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Movement Modifier 2", upgrade.getBonusValue("speed_modifier", level).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE))));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_POISON_RESIST = UPGRADES.register("poison_resist", () -> LivingArmorRegistrar.parseDefinition("poison_resist"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_FIRE_RESIST = UPGRADES.register("fire_resist", () -> LivingArmorRegistrar.parseDefinition("fire_resist"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_DIGGING = UPGRADES.register("digging", () -> LivingArmorRegistrar.parseDefinition("digging"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_KNOCKBACK_RESIST = UPGRADES.register("knockback_resist", () -> LivingArmorRegistrar.parseDefinition("knockback_resist").withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> {
        attributeMap.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "KB Modifier", upgrade.getBonusValue("kb", level).doubleValue(), AttributeModifier.Operation.ADDITION));
        attributeMap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(uuid, "Health Modifier 2", (double)upgrade.getBonusValue("hp", level).intValue(), AttributeModifier.Operation.ADDITION));
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_DIAMOND = UPGRADES.register("diamond_protect", () -> LivingArmorRegistrar.parseDefinition("diamond_protect").withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> {
        attributeMap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor Modifier", (double)upgrade.getBonusValue("armor", level).intValue(), AttributeModifier.Operation.ADDITION));
        attributeMap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Toughness Modifier", (double)upgrade.getBonusValue("toughness", level).intValue(), AttributeModifier.Operation.ADDITION));
    }));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_ELYTRA = UPGRADES.register("elytra", () -> LivingArmorRegistrar.parseDefinition("elytra"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_CURIOS_SOCKET = UPGRADES.register("curios_socket", () -> LivingArmorRegistrar.parseDefinition("curios_socket"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_MELEE_DAMAGE = UPGRADES.register("melee_damage", () -> LivingArmorRegistrar.parseDefinition("melee_damage").withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> attributeMap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "Damage Modifier 3", upgrade.getBonusValue("damage", level).doubleValue(), AttributeModifier.Operation.ADDITION))));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> UPGRADE_REPAIR = UPGRADES.register("repair", () -> LivingArmorRegistrar.parseDefinition("repair"));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_QUENCHED = UPGRADES.register("downgrade/quenched", () -> LivingArmorRegistrar.parseDefinition("downgrade/quenched").asDowngrade());
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_STORM_TROOPER = UPGRADES.register("downgrade/storm_trooper", () -> LivingArmorRegistrar.parseDefinition("downgrade/storm_trooper").asDowngrade());
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_BATTLE_HUNGRY = UPGRADES.register("downgrade/battle_hungry", () -> LivingArmorRegistrar.parseDefinition("downgrade/battle_hungry").asDowngrade());
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_MELEE_DECREASE = UPGRADES.register("downgrade/melee_decrease", () -> LivingArmorRegistrar.parseDefinition("downgrade/melee_decrease").asDowngrade().withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> attributeMap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "Damage Modifier 2", upgrade.getBonusValue("damage", level).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE))));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_DIG_SLOWDOWN = UPGRADES.register("downgrade/dig_slowdown", () -> LivingArmorRegistrar.parseDefinition("downgrade/dig_slowdown").asDowngrade());
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_SLOW_HEAL = UPGRADES.register("downgrade/slow_heal", () -> LivingArmorRegistrar.parseDefinition("downgrade/slow_heal").asDowngrade());
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_CRIPPLED_ARM = UPGRADES.register("downgrade/crippled_arm", () -> LivingArmorRegistrar.parseDefinition("downgrade/crippled_arm").asDowngrade());
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_SWIM_DECREASE = UPGRADES.register("downgrade/swim_decrease", () -> LivingArmorRegistrar.parseDefinition("downgrade/swim_decrease").asDowngrade().withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> attributeMap.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(uuid, "Swim Speed", upgrade.getBonusValue("speed_modifier", level).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE))));
    public static final LivingUpgradeRegistryObject<LivingUpgrade> DOWNGRADE_SPEED_DECREASE = UPGRADES.register("downgrade/speed_decrease", () -> LivingArmorRegistrar.parseDefinition("downgrade/speed_decrease").asDowngrade().withAttributeProvider((stats, attributeMap, uuid, upgrade, level) -> attributeMap.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Movement Modifier 3", upgrade.getBonusValue("speed_modifier", level).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE))));

    public static void register() {
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_ARROW_PROTECT.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_HEALTH.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_EXPERIENCE.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_SPRINT_ATTACK.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_SELF_SACRIFICE.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_SPEED.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_POISON_RESIST.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_DIGGING.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_FALL_PROTECT.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_PHYSICAL_PROTECT.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_JUMP.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_KNOCKBACK_RESIST.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_FIRE_RESIST.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_ELYTRA.get());
        if (BloodMagic.curiosLoaded.booleanValue()) {
            LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_CURIOS_SOCKET.get());
        }
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_DIAMOND.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_MELEE_DAMAGE.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)UPGRADE_REPAIR.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)DOWNGRADE_QUENCHED.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)DOWNGRADE_STORM_TROOPER.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)DOWNGRADE_BATTLE_HUNGRY.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)DOWNGRADE_MELEE_DECREASE.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)DOWNGRADE_DIG_SLOWDOWN.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)DOWNGRADE_SLOW_HEAL.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)DOWNGRADE_CRIPPLED_ARM.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)DOWNGRADE_SWIM_DECREASE.get());
        LivingArmorRegistrar.registerUpgrade((LivingUpgrade)DOWNGRADE_SPEED_DECREASE.get());
    }

    public static void registerUpgrade(LivingUpgrade upgrade) {
        UPGRADE_MAP.put(upgrade.getKey(), upgrade);
    }

    public static LivingUpgrade parseDefinition(String fileName) {
        ResourceLocation path = DEFINITIONS.get(fileName);
        if (path == null) {
            return LivingUpgrade.DUMMY;
        }
        try {
            URL schematicURL = LivingUpgrade.class.getResource(LivingArmorRegistrar.resLocToResourcePath(path));
            System.out.println("Attempting to load Living Armour Upgrade: " + schematicURL + ", path: " + LivingArmorRegistrar.resLocToResourcePath(path));
            return (LivingUpgrade)Serializers.GSON.fromJson(Resources.toString((URL)schematicURL, (Charset)Charsets.UTF_8), LivingUpgrade.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return LivingUpgrade.DUMMY;
        }
    }

    public static String resLocToResourcePath(ResourceLocation resourceLocation) {
        return "/data/" + resourceLocation.m_135827_() + "/living_armor/" + resourceLocation.m_135815_() + ".json";
    }
}

