/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;

public class CompositeFilterKey
implements IFilterKey {
    private List<IFilterKey> keyList = new ArrayList<IFilterKey>();
    private int count;

    public CompositeFilterKey(int count) {
        this.count = count;
    }

    public void addFilterKey(IFilterKey key) {
        if (!(key instanceof CompositeFilterKey)) {
            this.keyList.add(key);
        }
    }

    @Override
    public boolean doesStackMatch(ItemStack testStack) {
        if (testStack.m_41619_()) {
            return false;
        }
        for (IFilterKey key : this.keyList) {
            if (key.doesStackMatch(testStack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void shrink(int changeAmount) {
        this.count -= changeAmount;
    }

    @Override
    public void grow(int changeAmount) {
        this.count += changeAmount;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }
}

