/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockDemonCrystal;
import wayoftime.bloodmagic.common.tile.TileDemonCrystal;

public class ItemCrystalCatalyst
extends Item {
    public final EnumDemonWillType type;
    public final double injectedWill;
    public final double speedModifier;
    public final double conversionRate;
    public final double maxInjectedWill;

    public ItemCrystalCatalyst(EnumDemonWillType type, double injectedWill, double speedModifier, double conversionRate, double maxInjectedWill) {
        super(new Item.Properties());
        this.type = type;
        this.injectedWill = injectedWill;
        this.speedModifier = speedModifier;
        this.conversionRate = conversionRate;
        this.maxInjectedWill = maxInjectedWill;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.crystalCatalyst").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileDemonCrystal) {
            TileDemonCrystal crystalTile;
            if (!world.f_46443_ && this.applyCatalyst(crystalTile = (TileDemonCrystal)tile)) {
                ServerLevel server = (ServerLevel)world;
                ItemStack crystalStack = BlockDemonCrystal.getItemStackDropped(this.type, 1);
                ItemParticleOption particleData = new ItemParticleOption(ParticleTypes.f_123752_, crystalStack);
                for (int i = 0; i < 8; ++i) {
                    server.m_8767_((ParticleOptions)particleData, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, 1, 0.2, 0.2, 0.2, 0.03);
                }
                stack.m_41764_(stack.m_41613_() - 1);
                world.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean applyCatalyst(TileDemonCrystal crystalTile) {
        if (this.type.equals((Object)crystalTile.getWillType()) && crystalTile.getInjectedWill() + this.injectedWill <= this.maxInjectedWill) {
            crystalTile.applyCatalyst(this.injectedWill, this.speedModifier, this.conversionRate);
            return true;
        }
        return false;
    }
}

