/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class FilterMergeAlchemyTableRecipeBuilder
extends BloodMagicRecipeBuilder<FilterMergeAlchemyTableRecipeBuilder> {
    private final Ingredient filter;
    private final List<Ingredient> input;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;
    private ItemStack outputStack = new ItemStack((ItemLike)BloodMagicItems.ITEM_ROUTER_FILTER.get());

    protected FilterMergeAlchemyTableRecipeBuilder(Ingredient filter, List<Ingredient> input, int syphon, int ticks, int minimumTier) {
        super(FilterMergeAlchemyTableRecipeBuilder.bmSerializer("filteralchemytable"));
        this.filter = filter;
        this.input = input;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static FilterMergeAlchemyTableRecipeBuilder alchemyTable(Ingredient filter, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new FilterMergeAlchemyTableRecipeBuilder(filter, inputList, syphon, ticks, minimumTier);
    }

    public FilterMergeAlchemyTableRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 6) {
            this.input.add(ing);
        }
        return this;
    }

    public FilterMergeAlchemyTableRecipeBuilder addOptionalOutputStack(ItemStack outputStack) {
        this.outputStack = outputStack;
        return this;
    }

    @Override
    protected AlchemyTableRecipeResult getResult(ResourceLocation id) {
        return new AlchemyTableRecipeResult(id);
    }

    public class AlchemyTableRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected AlchemyTableRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("filter", FilterMergeAlchemyTableRecipeBuilder.this.filter.m_43942_());
            if (FilterMergeAlchemyTableRecipeBuilder.this.input.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Ingredient ing : FilterMergeAlchemyTableRecipeBuilder.this.input) {
                    JsonElement jsonObj = ing.m_43942_();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            json.add("output", SerializerHelper.serializeItemStack(FilterMergeAlchemyTableRecipeBuilder.this.outputStack));
            json.addProperty("syphon", (Number)FilterMergeAlchemyTableRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)FilterMergeAlchemyTableRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)FilterMergeAlchemyTableRecipeBuilder.this.minimumTier);
        }
    }
}

