/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class ARCRecipeBuilder
extends BloodMagicRecipeBuilder<ARCRecipeBuilder> {
    private final Ingredient input;
    private int inputSize = 1;
    private final Ingredient arcTool;
    private final FluidStackIngredient inputFluid;
    private final ItemStack output;
    private final FluidStack outputFluid;
    private final List<Pair<ItemStack, Pair<Double, Double>>> addedItems = new ArrayList<Pair<ItemStack, Pair<Double, Double>>>();
    private final boolean consumeIngredient;
    private double additionalMainOutputChance;

    protected ARCRecipeBuilder(Ingredient input, Ingredient arcTool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid, boolean consumeIngredient, double additionalMainOutputChance) {
        super(ARCRecipeBuilder.bmSerializer("arc"));
        this.input = input;
        this.arcTool = arcTool;
        this.inputFluid = inputFluid;
        this.output = output;
        this.outputFluid = outputFluid == null ? FluidStack.EMPTY : outputFluid;
        this.consumeIngredient = consumeIngredient;
        this.additionalMainOutputChance = additionalMainOutputChance;
    }

    public static ARCRecipeBuilder arc(Ingredient input, Ingredient arcTool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid) {
        return new ARCRecipeBuilder(input, arcTool, inputFluid, output, outputFluid, false, 0.0);
    }

    public static ARCRecipeBuilder arcConsume(Ingredient input, Ingredient arcTool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid) {
        return new ARCRecipeBuilder(input, arcTool, inputFluid, output, outputFluid, true, 0.0);
    }

    public ARCRecipeBuilder setRequiredInputCount(int inputSize) {
        if (inputSize > 0) {
            this.inputSize = inputSize;
        }
        return this;
    }

    public ARCRecipeBuilder addRandomOutput(ItemStack stack, double secondaryChance) {
        return this.addRandomOutput(stack, 0.0, secondaryChance);
    }

    public ARCRecipeBuilder addRandomOutput(ItemStack stack, double mainChance, double secondaryChance) {
        if (this.addedItems.size() >= 3 || mainChance < 0.0 || secondaryChance < 0.0) {
            return this;
        }
        this.addedItems.add((Pair<ItemStack, Pair<Double, Double>>)Pair.of((Object)stack, (Object)Pair.of((Object)mainChance, (Object)secondaryChance)));
        return this;
    }

    @Override
    protected ARCRecipeResult getResult(ResourceLocation id) {
        return new ARCRecipeResult(id);
    }

    public class ARCRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected ARCRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("input", ARCRecipeBuilder.this.input.m_43942_());
            json.addProperty("inputsize", (Number)ARCRecipeBuilder.this.inputSize);
            json.add("tool", ARCRecipeBuilder.this.arcTool.m_43942_());
            if (ARCRecipeBuilder.this.inputFluid != null) {
                json.add("inputFluid", ARCRecipeBuilder.this.inputFluid.serialize());
            }
            if (ARCRecipeBuilder.this.addedItems.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Pair<ItemStack, Pair<Double, Double>> pair : ARCRecipeBuilder.this.addedItems) {
                    JsonObject jsonObj = new JsonObject();
                    jsonObj.addProperty("mainchance", (Number)Float.valueOf(((Double)((Pair)pair.getValue()).getLeft()).floatValue()));
                    jsonObj.addProperty("chance", (Number)Float.valueOf(((Double)((Pair)pair.getValue()).getRight()).floatValue()));
                    jsonObj.add("type", SerializerHelper.serializeItemStack((ItemStack)pair.getKey()));
                    mainArray.add((JsonElement)jsonObj);
                }
                json.add("addedoutput", (JsonElement)mainArray);
            }
            if (ARCRecipeBuilder.this.outputFluid != null && !ARCRecipeBuilder.this.outputFluid.isEmpty()) {
                json.add("outputFluid", SerializerHelper.serializeFluidStack(ARCRecipeBuilder.this.outputFluid));
            }
            json.add("output", SerializerHelper.serializeItemStack(ARCRecipeBuilder.this.output));
            json.addProperty("consumeingredient", Boolean.valueOf(ARCRecipeBuilder.this.consumeIngredient));
            json.addProperty("mainoutputchance", (Number)ARCRecipeBuilder.this.additionalMainOutputChance);
        }
    }
}

