/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.container;

import com.traverse.bhc.common.config.ConfigHandler;
import com.traverse.bhc.common.init.RegistryHandler;
import com.traverse.bhc.common.items.BaseHeartCanister;
import com.traverse.bhc.common.items.ItemHeartAmulet;
import com.traverse.bhc.common.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class HeartAmuletContainer
extends AbstractContainerMenu {
    public static final String HEART_AMOUNT = "heart_amount";
    public ItemStackHandler itemStackHandler;

    public HeartAmuletContainer(int windowId, Inventory playerInventory, ItemStack stack) {
        super((MenuType)RegistryHandler.HEART_AMUlET_CONTAINER.get(), windowId);
        int row;
        this.itemStackHandler = InventoryUtil.createVirtualInventory(4, stack);
        this.m_38897_((Slot)new SlotPendant((IItemHandler)this.itemStackHandler, 0, 80, 9));
        this.m_38897_((Slot)new SlotPendant((IItemHandler)this.itemStackHandler, 1, 53, 33));
        this.m_38897_((Slot)new SlotPendant((IItemHandler)this.itemStackHandler, 2, 107, 33));
        this.m_38897_((Slot)new SlotPendant((IItemHandler)this.itemStackHandler, 3, 80, 57));
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = 142;
            if (row == this.getSlotFor(playerInventory, stack)) {
                this.m_38897_(new LockedSlot(playerInventory, row, x, y));
                continue;
            }
            this.m_38897_(new Slot((Container)playerInventory, row, x, y));
        }
        for (row = 1; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 66;
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9, x, y));
            }
        }
    }

    public void m_6877_(Player playerIn) {
        InteractionHand hand = ItemHeartAmulet.getHandForAmulet(playerIn);
        if (hand == null) {
            return;
        }
        InventoryUtil.serializeInventory(this.itemStackHandler, playerIn.m_21120_(hand));
        CompoundTag nbt = playerIn.m_21120_(hand).m_41783_();
        int[] hearts = new int[this.itemStackHandler.getSlots()];
        for (int i = 0; i < hearts.length; ++i) {
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            hearts[i] = stack.m_41613_() * 2;
        }
        nbt.m_128385_(HEART_AMOUNT, hearts);
        playerIn.m_21120_(hand).m_41751_(nbt);
        super.m_6877_(playerIn);
    }

    public boolean m_6875_(Player playerIn) {
        return InventoryUtil.hasAmulet(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index < this.itemStackHandler.getSlots()) {
                if (!this.m_38903_(slotStack, this.itemStackHandler.getSlots(), this.f_38839_.size(), true)) {
                    // empty if block
                }
                return ItemStack.f_41583_;
            }
            if (!this.m_38903_(slotStack, 0, this.itemStackHandler.getSlots(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack;
    }

    public int getSlotFor(Inventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            if (((ItemStack)inventory.f_35974_.get(i)).m_41619_() || !this.stackEqualExact(stack, (ItemStack)inventory.f_35974_.get(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() == stack2.m_41720_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    private static class SlotPendant
    extends SlotItemHandler {
        public SlotPendant(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return super.m_5857_(stack) && stack.m_41720_() instanceof BaseHeartCanister && ((BaseHeartCanister)stack.m_41720_()).type.ordinal() == this.getSlotIndex();
        }

        public int m_6641_() {
            return (Integer)ConfigHandler.general.heartStackSize.get();
        }
    }

    private static class LockedSlot
    extends Slot {
        public LockedSlot(Inventory inventoryIn, int index, int xPosition, int yPosition) {
            super((Container)inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }
    }
}

