/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item;

import artifacts.Artifacts;
import artifacts.client.item.model.ArmsModel;
import artifacts.client.item.model.BeltModel;
import artifacts.client.item.model.HeadModel;
import artifacts.client.item.model.LegsModel;
import artifacts.client.item.model.NecklaceModel;
import artifacts.client.item.model.ScarfModel;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;

public class ArtifactLayers {
    public static final ModelLayerLocation DRINKING_HAT = ArtifactLayers.createLayerLocation("drinking_hat");
    public static final ModelLayerLocation SNORKEL = ArtifactLayers.createLayerLocation("snorkel");
    public static final ModelLayerLocation NIGHT_VISION_GOGGLES = ArtifactLayers.createLayerLocation("night_vision_goggles");
    public static final ModelLayerLocation SUPERSTITIOUS_HAT = ArtifactLayers.createLayerLocation("superstitious_hat");
    public static final ModelLayerLocation VILLAGER_HAT = ArtifactLayers.createLayerLocation("villager_hat");
    public static final ModelLayerLocation SCARF = ArtifactLayers.createLayerLocation("scarf");
    public static final ModelLayerLocation CROSS_NECKLACE = ArtifactLayers.createLayerLocation("cross_necklace");
    public static final ModelLayerLocation PANIC_NECKLACE = ArtifactLayers.createLayerLocation("panic_necklace");
    public static final ModelLayerLocation PENDANT = ArtifactLayers.createLayerLocation("pendant");
    public static final ModelLayerLocation CHARM_OF_SINKING = ArtifactLayers.createLayerLocation("charm_of_sinking");
    public static final ModelLayerLocation CLOUD_IN_A_BOTTLE = ArtifactLayers.createLayerLocation("cloud_in_a_bottle");
    public static final ModelLayerLocation OBSIDIAN_SKULL = ArtifactLayers.createLayerLocation("obsidian_skull");
    public static final ModelLayerLocation ANTIDOTE_VESSEL = ArtifactLayers.createLayerLocation("antidote_vessel");
    public static final ModelLayerLocation UNIVERSAL_ATTRACTOR = ArtifactLayers.createLayerLocation("universal_attractor");
    public static final ModelLayerLocation CRYSTAL_HEART = ArtifactLayers.createLayerLocation("crystal_heart");
    public static final ModelLayerLocation HELIUM_FLAMINGO = ArtifactLayers.createLayerLocation("helium_flamingo");
    public static final ModelLayerLocation CLAWS = ArtifactLayers.createLayerLocation("claws");
    public static final ModelLayerLocation SLIM_CLAWS = ArtifactLayers.createLayerLocation("slim_claws");
    public static final ModelLayerLocation GLOVE = ArtifactLayers.createLayerLocation("gloves");
    public static final ModelLayerLocation SLIM_GLOVE = ArtifactLayers.createLayerLocation("slim_gloves");
    public static final ModelLayerLocation GOLDEN_HOOK = ArtifactLayers.createLayerLocation("golden_hook");
    public static final ModelLayerLocation SLIM_GOLDEN_HOOK = ArtifactLayers.createLayerLocation("slim_golden_hook");
    public static final ModelLayerLocation AQUA_DASHERS = ArtifactLayers.createLayerLocation("aqua_dashers");
    public static final ModelLayerLocation BUNNY_HOPPERS = ArtifactLayers.createLayerLocation("bunny_hoppers");
    public static final ModelLayerLocation KITTY_SLIPPERS = ArtifactLayers.createLayerLocation("kitty_slippers");
    public static final ModelLayerLocation RUNNING_SHOES = ArtifactLayers.createLayerLocation("running_shoes");
    public static final ModelLayerLocation STEADFAST_SPIKES = ArtifactLayers.createLayerLocation("steadfast_spikes");
    public static final ModelLayerLocation FLIPPERS = ArtifactLayers.createLayerLocation("flippers");
    public static final ModelLayerLocation WHOOPEE_CUSHION = ArtifactLayers.createLayerLocation("whoopee_cushion");

    public static ModelLayerLocation claws(boolean smallArms) {
        return smallArms ? SLIM_CLAWS : CLAWS;
    }

    public static ModelLayerLocation glove(boolean smallArms) {
        return smallArms ? SLIM_GLOVE : GLOVE;
    }

    public static ModelLayerLocation goldenHook(boolean smallArms) {
        return smallArms ? SLIM_GOLDEN_HOOK : GOLDEN_HOOK;
    }

    public static ModelLayerLocation createLayerLocation(String name) {
        return new ModelLayerLocation(Artifacts.id(name), name);
    }

    private static Supplier<LayerDefinition> layer(MeshDefinition mesh, int textureWidth, int textureHeight) {
        return () -> LayerDefinition.m_171565_((MeshDefinition)mesh, (int)textureWidth, (int)textureHeight);
    }

    public static void register() {
        EntityModelLayerRegistry.register((ModelLayerLocation)DRINKING_HAT, ArtifactLayers.layer(HeadModel.createDrinkingHat(), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)SNORKEL, ArtifactLayers.layer(HeadModel.createSnorkel(), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)NIGHT_VISION_GOGGLES, ArtifactLayers.layer(HeadModel.createNightVisionGoggles(), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)SUPERSTITIOUS_HAT, ArtifactLayers.layer(HeadModel.createSuperstitiousHat(), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)VILLAGER_HAT, ArtifactLayers.layer(HeadModel.createVillagerHat(), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)SCARF, ArtifactLayers.layer(ScarfModel.createScarf(), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)CROSS_NECKLACE, ArtifactLayers.layer(NecklaceModel.createCrossNecklace(), 64, 48));
        EntityModelLayerRegistry.register((ModelLayerLocation)PANIC_NECKLACE, ArtifactLayers.layer(NecklaceModel.createPanicNecklace(), 64, 48));
        EntityModelLayerRegistry.register((ModelLayerLocation)PENDANT, ArtifactLayers.layer(NecklaceModel.createPendant(), 64, 48));
        EntityModelLayerRegistry.register((ModelLayerLocation)CHARM_OF_SINKING, ArtifactLayers.layer(NecklaceModel.createCharmOfSinking(), 64, 48));
        EntityModelLayerRegistry.register((ModelLayerLocation)CLOUD_IN_A_BOTTLE, ArtifactLayers.layer(BeltModel.createCloudInABottle(), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)OBSIDIAN_SKULL, ArtifactLayers.layer(BeltModel.createObsidianSkull(), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)ANTIDOTE_VESSEL, ArtifactLayers.layer(BeltModel.createAntidoteVessel(), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)UNIVERSAL_ATTRACTOR, ArtifactLayers.layer(BeltModel.createUniversalAttractor(), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)CRYSTAL_HEART, ArtifactLayers.layer(BeltModel.createCrystalHeart(), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)HELIUM_FLAMINGO, ArtifactLayers.layer(BeltModel.createHeliumFlamingo(), 64, 64));
        EntityModelLayerRegistry.register((ModelLayerLocation)CLAWS, ArtifactLayers.layer(ArmsModel.createClaws(false), 32, 16));
        EntityModelLayerRegistry.register((ModelLayerLocation)SLIM_CLAWS, ArtifactLayers.layer(ArmsModel.createClaws(true), 32, 16));
        EntityModelLayerRegistry.register((ModelLayerLocation)GLOVE, ArtifactLayers.layer(ArmsModel.createSleevedArms(false), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)SLIM_GLOVE, ArtifactLayers.layer(ArmsModel.createSleevedArms(true), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)GOLDEN_HOOK, ArtifactLayers.layer(ArmsModel.createGoldenHook(false), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)SLIM_GOLDEN_HOOK, ArtifactLayers.layer(ArmsModel.createGoldenHook(true), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)AQUA_DASHERS, ArtifactLayers.layer(LegsModel.createAquaDashers(), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)BUNNY_HOPPERS, ArtifactLayers.layer(LegsModel.createBunnyHoppers(), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)KITTY_SLIPPERS, ArtifactLayers.layer(LegsModel.createKittySlippers(), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)RUNNING_SHOES, ArtifactLayers.layer(LegsModel.createRunningShoes(), 32, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)STEADFAST_SPIKES, ArtifactLayers.layer(LegsModel.createSteadfastSpikes(), 64, 32));
        EntityModelLayerRegistry.register((ModelLayerLocation)FLIPPERS, ArtifactLayers.layer(LegsModel.createFlippers(), 64, 64));
        EntityModelLayerRegistry.register((ModelLayerLocation)WHOOPEE_CUSHION, ArtifactLayers.layer(HeadModel.createWhoopeeCushion(), 32, 16));
    }
}

