/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.part;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.blockentity.powersink.IExternalPowerSink;
import appeng.items.parts.PartModels;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import gripe._90.arseng.ArsEnergistique;
import gripe._90.arseng.definition.ArsEngCapabilities;
import gripe._90.arseng.me.energy.SourceEnergyAdaptor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class SourceAcceptorPart
extends AEBasePart
implements IExternalPowerSink {
    @PartModels
    private static final IPartModel MODEL = new PartModel(ArsEnergistique.makeId("part/source_acceptor"));
    private final SourceEnergyAdaptor adapter = new SourceEnergyAdaptor(this, (IActionHost)this);

    public SourceAcceptorPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setIdlePowerUsage(0.0);
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    public float getCableConnectionLength(AECableType cable) {
        return 2.0f;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        return ArsEngCapabilities.SOURCE_TILE.orEmpty(capability, LazyOptional.of(() -> this.adapter));
    }

    public final double getExternalPowerDemand(PowerUnits externalUnit, double maxPowerRequired) {
        double demand = this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnits.AE, maxPowerRequired));
        return PowerUnits.AE.convertTo(externalUnit, Math.max(0.0, demand));
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? grid.getEnergyService().getEnergyDemand(maxRequired) : 0.0;
    }

    public final double injectExternalPower(PowerUnits input, double amt, Actionable mode) {
        return PowerUnits.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnits.AE, amt), mode));
    }

    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null ? grid.getEnergyService().injectPower(power, mode) : power;
    }

    public final double injectAEPower(double amt, Actionable mode) {
        return amt;
    }

    public final double getAEMaxPower() {
        return 0.0;
    }

    public final double getAECurrentPower() {
        return 0.0;
    }

    public final boolean isAEPublicPowerStorage() {
        return false;
    }

    public final AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return 0.0;
    }
}

