/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.storage;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import com.google.common.primitives.Ints;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.me.key.SourceKey;

public record GenericStackSourceStorage(GenericInternalInventory inv) implements IAdvancedSourceTile
{
    public int getTransferRate() {
        return Integer.MAX_VALUE;
    }

    public boolean canAcceptSource() {
        return this.insert(1, Actionable.SIMULATE) != 0;
    }

    public int getSource() {
        return this.extract(Integer.MAX_VALUE, Actionable.SIMULATE);
    }

    public int getMaxSource() {
        int slots = 0;
        for (int i = 0; i < this.inv.size(); ++i) {
            AEKey key = this.inv.getKey(i);
            if (key != null && key != SourceKey.KEY) continue;
            ++slots;
        }
        return Ints.saturatedCast((long)((long)slots * this.inv.getMaxAmount(SourceKey.KEY)));
    }

    public void setMaxSource(int max) {
        throw new UnsupportedOperationException();
    }

    public int setSource(int source) {
        throw new UnsupportedOperationException();
    }

    public int addSource(int source) {
        return this.insert(source, Actionable.MODULATE);
    }

    public int removeSource(int source) {
        return this.extract(source, Actionable.MODULATE);
    }

    private int insert(int amount, Actionable mode) {
        int inserted = 0;
        for (int i = 0; i < this.inv.size() && inserted < amount; inserted += Ints.saturatedCast((long)this.inv.insert(i, SourceKey.KEY, (long)(amount - inserted), mode)), ++i) {
        }
        return inserted;
    }

    private int extract(int amount, Actionable mode) {
        int extracted = 0;
        for (int i = 0; i < this.inv.size() && extracted < amount; extracted += Ints.saturatedCast((long)this.inv.extract(i, SourceKey.KEY, (long)(amount - extracted), mode)), ++i) {
        }
        return extracted;
    }

    @Override
    public boolean relayCanTakePower() {
        return true;
    }

    @Override
    public boolean sourcelinksCanProvidePower() {
        return false;
    }
}

