/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.definition;

import appeng.capabilities.Capabilities;
import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import gripe._90.arseng.ArsEnergistique;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.block.entity.SourceTileWrapper;
import gripe._90.arseng.me.storage.GenericStackSourceStorage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArsEngCapabilities {
    public static final Capability<IAdvancedSourceTile> SOURCE_TILE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IAdvancedSourceTile>(){});

    private ArsEngCapabilities() {
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(ISourceTile.class);
    }

    public static void attach(AttachCapabilitiesEvent<BlockEntity> event) {
        final BlockEntity be = (BlockEntity)event.getObject();
        if (be instanceof ISourceTile) {
            final ISourceTile sourceTile = (ISourceTile)be;
            ICapabilityProvider provider = new ICapabilityProvider(){
                private final LazyOptional<IAdvancedSourceTile> sourceHandler = LazyOptional.of(() -> new SourceTileWrapper(sourceTile, sourceTile instanceof AbstractSourceMachine && this.isNotBlackListed(sourceTile), sourceTile instanceof SourceJarTile));

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return SOURCE_TILE.orEmpty(cap, this.sourceHandler);
                }

                private void invalidate() {
                    this.sourceHandler.invalidate();
                }

                private boolean isNotBlackListed(ISourceTile tile) {
                    List<Class<ImbuementTile>> blacklistedClasses = List.of(ImbuementTile.class);
                    return blacklistedClasses.stream().noneMatch(clazz -> clazz.isInstance(tile));
                }
            };
            event.addCapability(ArsEnergistique.makeId("source_tile"), provider);
            event.addListener((provider)::invalidate);
        }
        ICapabilityProvider genericInvWrapper = new ICapabilityProvider(){
            private final Set<LazyOptional<ISourceTile>> sourceHandlers = new HashSet<LazyOptional<ISourceTile>>();

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                if (cap == SOURCE_TILE) {
                    LazyOptional handler = be.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(GenericStackSourceStorage::new);
                    this.sourceHandlers.add((LazyOptional<ISourceTile>)handler.cast());
                    return handler.cast();
                }
                return LazyOptional.empty();
            }

            private void invalidate() {
                this.sourceHandlers.forEach(LazyOptional::invalidate);
                this.sourceHandlers.clear();
            }
        };
        event.addCapability(ArsEnergistique.makeId("generic_inv_wrapper"), genericInvWrapper);
        event.addListener((genericInvWrapper)::invalidate);
    }
}

