/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.strategy;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.storage.MEStorage;
import appeng.util.BlockApiCache;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.definition.ArsEngCapabilities;
import gripe._90.arseng.me.key.SourceKey;
import gripe._90.arseng.me.key.SourceKeyType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceStorageImportStrategy
implements StackImportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceStorageImportStrategy.class);
    private final BlockApiCache<IAdvancedSourceTile> apiCache;
    private final Direction fromSide;

    public SourceStorageImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = BlockApiCache.create(ArsEngCapabilities.SOURCE_TILE, (ServerLevel)level, (BlockPos)fromPos);
        this.fromSide = fromSide;
    }

    public boolean transfer(StackTransferContext context) {
        long inserted;
        if (!context.isKeyTypeEnabled(SourceKeyType.TYPE)) {
            return false;
        }
        IAdvancedSourceTile sourceTile = (IAdvancedSourceTile)this.apiCache.find(this.fromSide);
        if (sourceTile == null) {
            return false;
        }
        int remainingTransferAmount = context.getOperationsRemaining() * SourceKeyType.TYPE.getAmountPerOperation();
        int rawAmount = Math.min(remainingTransferAmount, sourceTile.getSource());
        MEStorage inv = context.getInternalStorage().getInventory();
        long amount = inv.insert(SourceKey.KEY, (long)rawAmount, Actionable.SIMULATE, context.getActionSource());
        if (amount > 0L) {
            sourceTile.removeSource((int)amount);
        }
        if ((inserted = inv.insert(SourceKey.KEY, amount, Actionable.MODULATE, context.getActionSource())) < amount) {
            long leftover = amount - inserted;
            int backFill = (int)Math.min(leftover, (long)(sourceTile.getMaxSource() - sourceTile.getSource()));
            if (backFill > 0) {
                sourceTile.addSource(backFill);
            }
            if (leftover > (long)backFill) {
                LOGGER.error("Storage import issue, voided {} source.", (Object)(leftover - (long)backFill));
            }
        }
        long opsUsed = Math.max(1L, inserted / (long)SourceKeyType.TYPE.getAmountPerOperation());
        context.reduceOperationsRemaining(opsUsed);
        return amount > 0L;
    }
}

