/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.definition;

import appeng.api.features.P2PTunnelAttunement;
import appeng.api.parts.PartModels;
import appeng.core.definitions.ItemDefinition;
import appeng.items.materials.MaterialItem;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import appeng.items.storage.StorageTier;
import gripe._90.arseng.ArsEnergistique;
import gripe._90.arseng.item.CreativeSourceCellItem;
import gripe._90.arseng.item.PortableSourceCellItem;
import gripe._90.arseng.item.SourceCellItem;
import gripe._90.arseng.part.SourceAcceptorPart;
import gripe._90.arseng.part.SourceP2PTunnelPart;
import gripe._90.arseng.part.SpellP2PTunnelPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public final class ArsEngItems {
    private static final List<ItemDefinition<?>> ITEMS = new ArrayList();
    public static final ItemDefinition<MaterialItem> SOURCE_CELL_HOUSING = ArsEngItems.item("ME Source Cell Housing", "source_cell_housing", MaterialItem::new);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_1K = ArsEngItems.cell(StorageTier.SIZE_1K);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_4K = ArsEngItems.cell(StorageTier.SIZE_4K);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_16K = ArsEngItems.cell(StorageTier.SIZE_16K);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_64K = ArsEngItems.cell(StorageTier.SIZE_64K);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_256K = ArsEngItems.cell(StorageTier.SIZE_256K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL1K = ArsEngItems.portable(StorageTier.SIZE_1K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL4K = ArsEngItems.portable(StorageTier.SIZE_4K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL16K = ArsEngItems.portable(StorageTier.SIZE_16K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL64K = ArsEngItems.portable(StorageTier.SIZE_64K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL256K = ArsEngItems.portable(StorageTier.SIZE_256K);
    public static final ItemDefinition<CreativeSourceCellItem> CREATIVE_SOURCE_CELL = ArsEngItems.item("Creative ME Source Cell", "creative_source_cell", CreativeSourceCellItem::new);
    public static final ItemDefinition<PartItem<SourceP2PTunnelPart>> SOURCE_P2P_TUNNEL = (ItemDefinition)Util.m_137537_(() -> {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(SourceP2PTunnelPart.class));
        return ArsEngItems.item("ME Source P2P Tunnel", "source_p2p_tunnel", p -> new PartItem(p, SourceP2PTunnelPart.class, SourceP2PTunnelPart::new));
    });
    public static final ItemDefinition<PartItem<SpellP2PTunnelPart>> SPELL_P2P_TUNNEL = (ItemDefinition)Util.m_137537_(() -> {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(SpellP2PTunnelPart.class));
        return ArsEngItems.item("ME Spell P2P Tunnel", "spell_p2p_tunnel", p -> new PartItem(p, SpellP2PTunnelPart.class, SpellP2PTunnelPart::new));
    });
    public static final ItemDefinition<PartItem<SourceAcceptorPart>> SOURCE_ACCEPTOR_PART = (ItemDefinition)Util.m_137537_(() -> {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(SourceAcceptorPart.class));
        return ArsEngItems.item("ME Source Acceptor", "cable_source_acceptor", p -> new PartItem(p, SourceAcceptorPart.class, SourceAcceptorPart::new));
    });

    private ArsEngItems() {
    }

    public static List<ItemDefinition<?>> getItems() {
        return Collections.unmodifiableList(ITEMS);
    }

    public static void register(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registries.f_256913_)) {
            ITEMS.forEach(i -> ForgeRegistries.ITEMS.register(i.id(), (Object)i.m_5456_()));
        }
    }

    public static void initP2PAttunement(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            P2PTunnelAttunement.registerAttunementTag(SOURCE_P2P_TUNNEL);
            P2PTunnelAttunement.registerAttunementTag(SPELL_P2P_TUNNEL);
        });
    }

    public static List<ItemDefinition<SourceCellItem>> getCells() {
        return List.of(SOURCE_CELL_1K, SOURCE_CELL_4K, SOURCE_CELL_16K, SOURCE_CELL_64K, SOURCE_CELL_256K);
    }

    public static List<ItemDefinition<PortableSourceCellItem>> getPortables() {
        return List.of(PORTABLE_SOURCE_CELL1K, PORTABLE_SOURCE_CELL4K, PORTABLE_SOURCE_CELL16K, PORTABLE_SOURCE_CELL64K, PORTABLE_SOURCE_CELL256K);
    }

    private static ItemDefinition<SourceCellItem> cell(StorageTier tier) {
        return ArsEngItems.item(tier.namePrefix() + " ME Source Storage Cell", "source_storage_cell_" + tier.namePrefix(), p -> new SourceCellItem(p.m_41487_(1), tier));
    }

    private static ItemDefinition<PortableSourceCellItem> portable(StorageTier tier) {
        return ArsEngItems.item(tier.namePrefix() + " Portable Source Cell", "portable_source_cell_" + tier.namePrefix(), p -> new PortableSourceCellItem(p.m_41487_(1), tier));
    }

    public static <T extends Item> ItemDefinition<T> item(String englishName, String id, Function<Item.Properties, T> factory) {
        ItemDefinition definition = new ItemDefinition(englishName, ArsEnergistique.makeId(id), (Item)factory.apply(new Item.Properties()));
        ITEMS.add(definition);
        return definition;
    }
}

