/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MycelialSourcelinkTile
extends SourcelinkTile {
    public MycelialSourcelinkTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public MycelialSourcelinkTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.MYCELIAL_TILE, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % 40L == 0L && this.canAcceptSource()) {
            ItemStack containerItem;
            for (ItemEntity itemEntity : this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82400_(1.0))) {
                if (!itemEntity.m_32055_().m_41720_().m_41472_()) continue;
                int source = this.getSourceValue(itemEntity.m_32055_());
                this.addSource(source);
                containerItem = itemEntity.m_32055_().getCraftingRemainingItem();
                itemEntity.m_32055_().m_41774_(1);
                if (!containerItem.m_41619_()) {
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), containerItem));
                }
                Networking.sendToNearby(this.f_58857_, this.m_58899_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, itemEntity.m_20183_(), new ParticleColor(255, 255, 255), new int[0]));
            }
            for (ArcanePedestalTile arcanePedestalTile : this.getSurroundingPedestals()) {
                int sourceValue = this.getSourceValue(arcanePedestalTile.m_8020_(0));
                if (sourceValue <= 0) continue;
                this.addSource(sourceValue);
                containerItem = arcanePedestalTile.m_8020_(0).getCraftingRemainingItem();
                arcanePedestalTile.m_7407_(0, 1);
                arcanePedestalTile.m_6836_(0, containerItem);
                Networking.sendToNearby(this.f_58857_, this.m_58899_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, arcanePedestalTile.m_58899_().m_7494_(), new ParticleColor(255, 255, 255), new int[0]));
            }
        }
    }

    public int getSourceValue(ItemStack i) {
        if (i.m_41720_().m_41472_()) {
            BlockItem blockItem;
            Item item;
            int mana = 0;
            FoodProperties food = i.m_41720_().getFoodProperties(i, null);
            if (food == null) {
                return 0;
            }
            mana += 11 * food.m_38744_();
            mana = (int)((float)mana + 30.0f * food.m_38745_());
            ++this.progress;
            if (i.m_204117_(ItemTagProvider.MAGIC_FOOD) || (item = i.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_().m_49966_().m_204336_(BlockTagProvider.MAGIC_PLANTS)) {
                this.progress += 4;
                mana += 10;
                mana *= 2;
            }
            return mana;
        }
        return 0;
    }

    @Override
    public void doRandomAction() {
        BlockPos dirtPos;
        super.doRandomAction();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.progress > 10) {
            for (BlockPos p : BlockPos.m_121925_((BlockPos)this.f_58858_, (int)1, (int)0, (int)1)) {
                if (!this.f_58857_.m_8055_(p).m_60795_() || this.f_58857_.m_8055_(p.m_7495_()).m_60734_() != Blocks.f_50195_) continue;
                this.f_58857_.m_46597_(p, (double)this.f_58857_.m_213780_().m_188501_() > 0.5 ? Blocks.f_50072_.m_49966_() : Blocks.f_50073_.m_49966_());
                this.progress -= 10;
                break;
            }
        }
        BlockPos blockPos = dirtPos = (dirtPos = this.getBlockInArea(Blocks.f_50493_, 1)) == null ? this.getBlockInArea(Blocks.f_50440_, 1) : dirtPos;
        if (dirtPos != null && this.progress >= 25) {
            this.f_58857_.m_46597_(dirtPos, Blocks.f_50195_.m_49966_());
            this.progress -= 25;
        }
    }

    public BlockPos getBlockInArea(Block block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.m_121990_((BlockPos)this.f_58858_.m_7918_(range, -1, range), (BlockPos)this.f_58858_.m_7918_(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.m_7949_();
            if (posFound.get() == null && this.f_58857_.m_8055_(blockPos).m_60734_() == block) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }
}

