/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.client.gui.GlyphRecipeTooltip;
import com.hollingsworth.arsnouveau.client.gui.NoShadowTextField;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.buttons.GlyphButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.ItemButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.SelectableButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.UnlockGlyphButton;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetScribeRecipe;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CreativeTabRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import org.joml.Matrix4f;

public class GlyphUnlockMenu
extends BaseBook {
    public List<AbstractSpellPart> displayedGlyphs = new ArrayList<AbstractSpellPart>();
    public List<AbstractSpellPart> allParts = new ArrayList<AbstractSpellPart>();
    public int page = 0;
    public PageButton nextButton;
    public PageButton previousButton;
    public List<UnlockGlyphButton> glyphButtons = new ArrayList<UnlockGlyphButton>();
    public NoShadowTextField searchBar;
    public String previousString = "";
    int maxPerPage = 78;
    int tier1Row = 0;
    int tier2Row = 0;
    int tier3Row = 0;
    BlockPos scribesPos;
    Filter filterSelected = Filter.ALL;
    public GlyphRecipe hoveredRecipe;
    public GlyphRecipe selectedRecipe;
    String orderingTitle = "";
    List<ItemButton> itemButtons = new ArrayList<ItemButton>();
    List<SelectableButton> filterButtons = new ArrayList<SelectableButton>();
    SelectableButton all;
    SelectableButton tier1;
    SelectableButton tier2;
    SelectableButton tier3;

    public GlyphUnlockMenu(BlockPos pos) {
        this.allParts = new ArrayList<AbstractSpellPart>(GlyphRegistry.getSpellpartMap().values().stream().filter(AbstractSpellPart::shouldShowInUnlock).toList());
        this.displayedGlyphs = new ArrayList<AbstractSpellPart>(this.allParts);
        this.scribesPos = pos;
    }

    public static void open(BlockPos scribePos) {
        Minecraft.m_91087_().m_91152_((Screen)new GlyphUnlockMenu(scribePos));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.orderingTitle = Component.m_237115_((String)"ars_nouveau.all_glyphs").getString();
        this.searchBar = new NoShadowTextField(this.f_96541_.f_91062_, this.bookRight - 73, this.bookTop + 2, 54, 12, null, (Component)Component.m_237115_((String)"ars_nouveau.spell_book_gui.search"));
        this.searchBar.m_94182_(false);
        this.searchBar.m_94202_(12694931);
        this.searchBar.onClear = val -> {
            this.onSearchChanged("");
            return null;
        };
        if (this.searchBar.m_94155_().isEmpty()) {
            this.searchBar.m_94167_(Component.m_237115_((String)"ars_nouveau.spell_book_gui.search").getString());
        }
        this.searchBar.m_94151_(val -> this.onSearchChanged((String)val));
        this.m_142416_((GuiEventListener)this.searchBar);
        this.m_142416_((GuiEventListener)new GuiImageButton(this.bookRight - 71, this.bookBottom - 13, 50, 12, new ResourceLocation("ars_nouveau", "textures/gui/create_icon.png"), this::onSelectClick));
        this.nextButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.bookRight - 20, this.bookBottom - 10, true, this::onPageIncrease, true));
        this.previousButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.bookLeft - 5, this.bookBottom - 10, false, this::onPageDec, true));
        this.updateNextPageButtons();
        this.previousButton.f_93623_ = false;
        this.previousButton.f_93624_ = false;
        this.layoutAllGlyphs(0);
        for (int i = 0; i < 10; ++i) {
            int offset = i >= 5 ? 14 : 0;
            ItemButton cell = new ItemButton(this, this.bookLeft + 19 + 24 * i + offset, this.bookTop + 194 - 47);
            this.m_142416_((GuiEventListener)cell);
            this.itemButtons.add(cell);
        }
        this.all = (SelectableButton)new SelectableButton(this.bookRight - 8, this.bookTop + 22, 0, 0, 23, 20, 23, 20, new ResourceLocation("ars_nouveau", "textures/gui/filter_tab_all.png"), new ResourceLocation("ars_nouveau", "textures/gui/filter_tab_all_selected.png"), b -> this.setFilter(Filter.ALL, (SelectableButton)b, Component.m_237115_((String)"ars_nouveau.all_glyphs").getString())).withTooltip((Component)Component.m_237115_((String)"ars_nouveau.all_glyphs"));
        this.all.isSelected = true;
        this.tier1 = (SelectableButton)new SelectableButton(this.bookRight - 8, this.bookTop + 46, 0, 0, 23, 20, 23, 20, new ResourceLocation("ars_nouveau", "textures/gui/filter_tab_tier1.png"), new ResourceLocation("ars_nouveau", "textures/gui/filter_tab_tier1_selected.png"), b -> this.setFilter(Filter.TIER1, (SelectableButton)b, Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{1}).getString())).withTooltip((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{1}));
        this.tier2 = (SelectableButton)new SelectableButton(this.bookRight - 8, this.bookTop + 70, 0, 0, 23, 20, 23, 20, new ResourceLocation("ars_nouveau", "textures/gui/filter_tab_tier2.png"), new ResourceLocation("ars_nouveau", "textures/gui/filter_tab_tier2_selected.png"), b -> this.setFilter(Filter.TIER2, (SelectableButton)b, Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{2}).getString())).withTooltip((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{2}));
        this.tier3 = (SelectableButton)new SelectableButton(this.bookRight - 8, this.bookTop + 94, 0, 0, 23, 20, 23, 20, new ResourceLocation("ars_nouveau", "textures/gui/filter_tab_tier3.png"), new ResourceLocation("ars_nouveau", "textures/gui/filter_tab_tier3_selected.png"), b -> this.setFilter(Filter.TIER3, (SelectableButton)b, Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{3}).getString())).withTooltip((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{3}));
        this.filterButtons.add(this.all);
        this.filterButtons.add(this.tier2);
        this.filterButtons.add(this.tier1);
        this.filterButtons.add(this.tier3);
        for (SelectableButton button : this.filterButtons) {
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void setFilter(Filter filter, SelectableButton button, String displayTitle) {
        this.displayedGlyphs = this.allParts;
        for (SelectableButton b : this.filterButtons) {
            b.isSelected = false;
        }
        this.filterSelected = filter;
        button.isSelected = true;
        this.orderingTitle = displayTitle;
        this.onSearchChanged(this.searchBar.f_94093_);
        this.resetPageState();
    }

    private void onSelectClick(Button button) {
        if (this.selectedRecipe != null) {
            Networking.INSTANCE.sendToServer((Object)new PacketSetScribeRecipe(this.scribesPos, this.selectedRecipe.id));
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public void updateNextPageButtons() {
        if (this.displayedGlyphs.size() < this.maxPerPage) {
            this.nextButton.f_93624_ = false;
            this.nextButton.f_93623_ = false;
        } else {
            this.nextButton.f_93624_ = true;
            this.nextButton.f_93623_ = true;
        }
    }

    public void onSearchChanged(String str) {
        this.previousString = str;
        if (!str.isEmpty()) {
            this.searchBar.m_94167_("");
            this.displayedGlyphs = new ArrayList<AbstractSpellPart>();
            for (AbstractSpellPart spellPart : this.allParts) {
                if (!spellPart.getLocaleName().toLowerCase().contains(this.searchBar.f_94093_.toLowerCase())) continue;
                this.displayedGlyphs.add(spellPart);
            }
            for (Renderable w : this.f_169369_) {
                AbstractSpellPart part;
                if (!(w instanceof GlyphButton)) continue;
                GlyphButton glyphButton = (GlyphButton)w;
                if (glyphButton.abstractSpellPart.getRegistryName() == null || (part = GlyphRegistry.getSpellpartMap().get(glyphButton.abstractSpellPart.getRegistryName())) == null) continue;
                glyphButton.f_93624_ = part.getLocaleName().toLowerCase().contains(this.searchBar.f_94093_.toLowerCase());
            }
        } else {
            this.searchBar.m_94167_(Component.m_237115_((String)"ars_nouveau.spell_book_gui.search").getString());
            this.displayedGlyphs = this.allParts;
            for (Renderable w : this.f_169369_) {
                if (!(w instanceof GlyphButton)) continue;
                ((GlyphButton)w).f_93624_ = true;
            }
        }
        this.displayedGlyphs = this.applyFilter(this.displayedGlyphs);
        this.resetPageState();
    }

    public void resetPageState() {
        this.updateNextPageButtons();
        this.page = 0;
        this.previousButton.f_93623_ = false;
        this.previousButton.f_93624_ = false;
        this.layoutAllGlyphs(this.page);
    }

    public void layoutAllGlyphs(int page) {
        this.clearButtons(this.glyphButtons);
        this.tier1Row = -1;
        this.tier2Row = -1;
        this.tier3Row = -1;
        int PER_ROW = 6;
        int MAX_ROWS = 6;
        boolean nextPage = false;
        int xStart = nextPage ? this.bookLeft + 154 : this.bookLeft + 20;
        int adjustedRowsPlaced = 0;
        int yStart = this.bookTop + 20;
        List<AbstractSpellPart> sorted = new ArrayList<AbstractSpellPart>(this.displayedGlyphs);
        sorted.sort(CreativeTabRegistry.COMPARE_TIER_THEN_NAME);
        sorted = sorted.subList(this.maxPerPage * page, Math.min(sorted.size(), this.maxPerPage * (page + 1)));
        int adjustedXPlaced = 0;
        this.tier1Row = 0;
        ++adjustedRowsPlaced;
        for (int i = 0; i < sorted.size(); ++i) {
            AbstractSpellPart part = sorted.get(i);
            if (adjustedXPlaced >= 6) {
                ++adjustedRowsPlaced;
                adjustedXPlaced = 0;
            }
            if (adjustedRowsPlaced > 6) {
                if (nextPage) break;
                nextPage = true;
                adjustedXPlaced = 0;
                adjustedRowsPlaced = 0;
            }
            int xOffset = 20 * (adjustedXPlaced % 6) + (nextPage ? 134 : 0);
            int yPlace = adjustedRowsPlaced * 18 + yStart;
            UnlockGlyphButton cell = new UnlockGlyphButton(xStart + xOffset, yPlace, false, part, this::onGlyphClick);
            IPlayerCap cap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)Minecraft.m_91087_().f_91074_).orElse(null);
            if (cap != null && (cap.knowsGlyph(part) || GlyphRegistry.getDefaultStartingSpells().contains(part))) {
                cell.playerKnows = true;
            }
            this.m_142416_((GuiEventListener)cell);
            this.glyphButtons.add(cell);
            ++adjustedXPlaced;
        }
    }

    public List<AbstractSpellPart> applyFilter(List<AbstractSpellPart> spellParts) {
        if (this.filterSelected == Filter.ALL) {
            return spellParts;
        }
        if (this.filterSelected == Filter.TIER1) {
            return spellParts.stream().filter(a -> a.getConfigTier().value == 1).collect(Collectors.toList());
        }
        if (this.filterSelected == Filter.TIER2) {
            return spellParts.stream().filter(a -> a.getConfigTier().value == 2).collect(Collectors.toList());
        }
        return spellParts.stream().filter(a -> a.getConfigTier().value == 3).collect(Collectors.toList());
    }

    public void onGlyphClick(Button button) {
        for (ItemButton itemButton : this.itemButtons) {
            itemButton.f_93624_ = false;
            itemButton.ingredient = Ingredient.f_43901_;
        }
        for (UnlockGlyphButton button1 : this.glyphButtons) {
            button1.selected = false;
        }
        if (button instanceof UnlockGlyphButton) {
            UnlockGlyphButton unlockGlyphButton = (UnlockGlyphButton)button;
            this.selectedRecipe = unlockGlyphButton.recipe;
            unlockGlyphButton.selected = true;
            if (this.selectedRecipe == null) {
                return;
            }
            for (int i = 0; i < this.selectedRecipe.inputs.size() && i <= this.itemButtons.size(); ++i) {
                this.itemButtons.get((int)i).f_93624_ = true;
                this.itemButtons.get((int)i).ingredient = this.selectedRecipe.inputs.get(i);
            }
        }
    }

    public void clearButtons(List<UnlockGlyphButton> glyphButtons) {
        for (UnlockGlyphButton b : glyphButtons) {
            this.f_169369_.remove(b);
            this.m_6702_().remove(b);
        }
        glyphButtons.clear();
    }

    public void onPageIncrease(Button button) {
        ++this.page;
        if (this.displayedGlyphs.size() < this.maxPerPage * (this.page + 1)) {
            this.nextButton.f_93624_ = false;
            this.nextButton.f_93623_ = false;
        }
        this.previousButton.f_93623_ = true;
        this.previousButton.f_93624_ = true;
        this.layoutAllGlyphs(this.page);
    }

    public void onPageDec(Button button) {
        --this.page;
        if (this.page == 0) {
            this.previousButton.f_93623_ = false;
            this.previousButton.f_93624_ = false;
        }
        if (this.displayedGlyphs.size() > this.maxPerPage * (this.page + 1)) {
            this.nextButton.f_93624_ = true;
            this.nextButton.f_93623_ = true;
        }
        this.layoutAllGlyphs(this.page);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.hoveredRecipe = null;
        Renderable renderable = this.getHoveredRenderable(mouseX, mouseY);
        if (renderable instanceof UnlockGlyphButton) {
            UnlockGlyphButton button = (UnlockGlyphButton)renderable;
            this.hoveredRecipe = button.recipe;
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280056_(this.f_96547_, this.orderingTitle, this.tier1Row > 7 ? 154 : 20, 5 + 18 * (this.tier1Row + (this.tier1Row == 1 ? 0 : 1)), -8355712, false);
        graphics.m_280163_(new ResourceLocation("ars_nouveau", "textures/gui/create_paper.png"), 216, 179, 0.0f, 0.0f, 56, 15, 56, 15);
        graphics.m_280163_(new ResourceLocation("ars_nouveau", "textures/gui/search_paper.png"), 203, 0, 0.0f, 0.0f, 72, 15, 72, 15);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"ars_nouveau.spell_book_gui.select"), 233, 183, -8355712, false);
    }

    @Override
    public void drawTooltip(GuiGraphics stack, int mouseX, int mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        super.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (this.hoveredRecipe != null) {
            MutableComponent component = Component.m_237110_((String)"ars_nouveau.levels_required", (Object[])new Object[]{ScribesTile.getLevelsFromExp(this.hoveredRecipe.exp)}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
            tooltip.add((Component)component);
        }
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>(ForgeHooksClient.gatherTooltipComponents((ItemStack)ItemStack.f_41583_, tooltip, (int)mouseX, (int)this.f_96543_, (int)this.f_96544_, (Font)this.f_96547_));
        if (this.hoveredRecipe != null) {
            components.add(new GlyphRecipeTooltip(this.hoveredRecipe.inputs));
        }
        this.renderTooltipInternal(stack, components, mouseX, mouseY);
    }

    public void renderTooltipInternal(GuiGraphics graphics, List<ClientTooltipComponent> pClientTooltipComponents, int pMouseX, int pMouseY) {
        if (!pClientTooltipComponents.isEmpty()) {
            PoseStack pPoseStack = graphics.m_280168_();
            RenderTooltipEvent.Pre preEvent = ForgeHooksClient.onRenderTooltipPre((ItemStack)ItemStack.f_41583_, (GuiGraphics)graphics, (int)pMouseX, (int)pMouseY, (int)this.f_96543_, (int)this.f_96544_, pClientTooltipComponents, (Font)this.f_96547_, (ClientTooltipPositioner)DefaultTooltipPositioner.f_262752_);
            if (preEvent.isCanceled()) {
                return;
            }
            int i = 0;
            int j = pClientTooltipComponents.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent clienttooltipcomponent : pClientTooltipComponents) {
                int k = clienttooltipcomponent.m_142069_(preEvent.getFont());
                if (k > i) {
                    i = k;
                }
                j += clienttooltipcomponent.m_142103_();
            }
            int j2 = preEvent.getX() + 12;
            int k2 = preEvent.getY() - 12;
            if (j2 + i > this.f_96543_) {
                j2 -= 28 + i;
            }
            if (k2 + j + 6 > this.f_96544_) {
                k2 = this.f_96544_ - j - 6;
            }
            pPoseStack.m_85836_();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
            RenderTooltipEvent.Color colorEvent = ForgeHooksClient.onRenderTooltipColor((ItemStack)ItemStack.f_41583_, (GuiGraphics)graphics, (int)j2, (int)k2, (Font)preEvent.getFont(), pClientTooltipComponents);
            graphics.m_280120_(j2 - 3, k2 - 4, j2 + i + 3, k2 - 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundStart());
            graphics.m_280120_(j2 - 3, k2 + j + 3, j2 + i + 3, k2 + j + 4, 400, colorEvent.getBackgroundEnd(), colorEvent.getBackgroundEnd());
            graphics.m_280120_(j2 - 3, k2 - 3, j2 + i + 3, k2 + j + 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
            graphics.m_280120_(j2 - 4, k2 - 3, j2 - 3, k2 + j + 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
            graphics.m_280120_(j2 + i + 3, k2 - 3, j2 + i + 4, k2 + j + 3, 400, colorEvent.getBackgroundStart(), colorEvent.getBackgroundEnd());
            graphics.m_280120_(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + j + 3 - 1, 400, colorEvent.getBorderStart(), colorEvent.getBorderEnd());
            graphics.m_280120_(j2 + i + 2, k2 - 3 + 1, j2 + i + 3, k2 + j + 3 - 1, 400, colorEvent.getBorderStart(), colorEvent.getBorderEnd());
            graphics.m_280120_(j2 - 3, k2 - 3, j2 + i + 3, k2 - 3 + 1, 400, colorEvent.getBorderStart(), colorEvent.getBorderStart());
            graphics.m_280120_(j2 - 3, k2 + j + 2, j2 + i + 3, k2 + j + 3, 400, colorEvent.getBorderEnd(), colorEvent.getBorderEnd());
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.disableBlend();
            MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            pPoseStack.m_85837_(0.0, 0.0, 400.0);
            int l1 = k2;
            for (int i2 = 0; i2 < pClientTooltipComponents.size(); ++i2) {
                ClientTooltipComponent clienttooltipcomponent1 = pClientTooltipComponents.get(i2);
                clienttooltipcomponent1.m_142440_(preEvent.getFont(), j2, l1, matrix4f, multibuffersource$buffersource);
                l1 += clienttooltipcomponent1.m_142103_() + (i2 == 0 ? 2 : 0);
            }
            multibuffersource$buffersource.m_109911_();
            l1 = k2;
            pPoseStack.m_252880_(0.0f, 0.0f, 600.0f);
            for (int l2 = 0; l2 < pClientTooltipComponents.size(); ++l2) {
                ClientTooltipComponent clienttooltipcomponent2 = pClientTooltipComponents.get(l2);
                clienttooltipcomponent2.m_183452_(preEvent.getFont(), j2, l1, graphics);
                l1 += clienttooltipcomponent2.m_142103_() + (l2 == 0 ? 2 : 0);
            }
            pPoseStack.m_85849_();
        }
    }

    static enum Filter {
        ALL,
        TIER1,
        TIER2,
        TIER3;

    }
}

