/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.foci;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.items.ElementalCurio;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class ElementalFocus
extends ElementalCurio
implements ISchoolFocus {
    protected SpellSchool element;

    @Override
    public double getDiscount() {
        return (Double)ConfigHandler.COMMON.LesserFocusDiscount.get();
    }

    public ElementalFocus(Item.Properties properties, SpellSchool element) {
        super(properties);
        this.element = element;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        ServerPlayer player;
        Player player2 = pContext.m_43723_();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).m_20148_().equals(ArsElemental.Dev) && player.m_6047_()) {
            pContext.m_43725_().m_7967_((Entity)new ItemEntity(pContext.m_43725_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), ((Item)ModItems.DEBUG_ICON.get()).m_7968_()));
        }
        return super.m_6225_(pContext);
    }

    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        if (SpellSchools.ELEMENTAL.isPartOfSchool(spellPart)) {
            if (this.element.isPartOfSchool(spellPart)) {
                builder.addAmplification(this.getBoostMultiplier());
            } else {
                builder.addAmplification(this.getMalusMultiplier());
            }
        }
        return builder;
    }

    @Override
    public SpellSchool getSchool() {
        return this.element;
    }

    public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        return stack.m_41720_() instanceof ElementalFocus && ((ElementalFocus)stack.m_41720_()).element == SpellSchools.ELEMENTAL_AIR;
    }

    double getBoostMultiplier() {
        return switch (this.element.getId()) {
            case "fire" -> (Double)ConfigHandler.COMMON.FireMasteryBuff.get();
            case "water" -> (Double)ConfigHandler.COMMON.WaterMasteryBuff.get();
            case "air" -> (Double)ConfigHandler.COMMON.AirMasteryBuff.get();
            case "earth" -> (Double)ConfigHandler.COMMON.EarthMasteryBuff.get();
            default -> 0.0;
        };
    }

    double getMalusMultiplier() {
        return switch (this.element.getId()) {
            case "fire" -> (Double)ConfigHandler.COMMON.FireMasteryDebuff.get();
            case "water" -> (Double)ConfigHandler.COMMON.WaterMasteryDebuff.get();
            case "air" -> (Double)ConfigHandler.COMMON.AirMasteryDebuff.get();
            case "earth" -> (Double)ConfigHandler.COMMON.EarthMasteryDebuff.get();
            default -> 0.0;
        };
    }

    @NotNull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return switch (this.element.getId()) {
            case "fire" -> new ICurio.SoundInfo(SoundEvents.f_11936_, 1.0f, 1.0f);
            case "water" -> new ICurio.SoundInfo(SoundEvents.f_11776_, 1.0f, 1.0f);
            case "earth" -> new ICurio.SoundInfo(SoundEvents.f_144206_, 1.0f, 1.0f);
            case "air" -> new ICurio.SoundInfo(SoundEvents.f_12090_, 1.0f, 1.0f);
            default -> super.getEquipSound(slotContext, stack);
        };
    }
}

