/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spells;

import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.entity.EntityLingeringSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityMagnetSpell
extends EntityLingeringSpell {
    List<Predicate<Entity>> ignored;

    public EntityMagnetSpell(EntityType<? extends EntityProjectileSpell> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityMagnetSpell(Level worldIn) {
        super((EntityType)ModEntities.LINGER_MAGNET.get(), worldIn);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.LINGER_MAGNET.get();
    }

    public static void createMagnet(Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, Vec3 location) {
        EntityMagnetSpell magnet = new EntityMagnetSpell(world);
        magnet.ignored = EntityMagnetSpell.makeIgnores(shooter, spellContext.getSpell(), spellContext.getCurrentIndex() + 1);
        magnet.m_146884_(location);
        magnet.setAoe((float)spellStats.getAoeMultiplier());
        magnet.m_5602_((Entity)shooter);
        magnet.extendedTime = spellStats.getDurationMultiplier();
        magnet.setColor(spellContext.getColors());
        world.m_7967_((Entity)magnet);
    }

    public float getAoe() {
        return super.getAoe() / 2.0f;
    }

    public void m_8119_() {
        ++this.age;
        if (this.age > this.getExpirationTime()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.f_19853_.m_5776_() && this.age > this.getParticleDelay()) {
            this.playParticles();
        }
        if (!this.f_19853_.m_5776_() && this.age % 5 == 0) {
            for (Entity entity : this.f_19853_.m_45933_((Entity)this, new AABB(this.m_20183_()).m_82400_((double)this.getAoe()))) {
                Vec3 vec3d;
                if (this.testFilters(entity) || (vec3d = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20186_() - entity.m_20186_(), this.m_20189_() - entity.m_20189_())).m_82553_() < 1.0) continue;
                entity.m_20256_(entity.m_20184_().m_82549_(vec3d.m_82541_()).m_82490_(0.5));
                entity.f_19864_ = true;
            }
        }
    }

    public boolean testFilters(Entity entity) {
        return this.ignored.stream().anyMatch(filter -> filter.test(entity));
    }

    public static List<Predicate<Entity>> makeIgnores(LivingEntity shooter, Spell spell, int index) {
        ArrayList<Predicate<Entity>> ignore = new ArrayList<Predicate<Entity>>();
        ignore.add(entity -> entity instanceof EntityLingeringSpell);
        ignore.add(entity -> entity == shooter);
        ignore.add(entity -> entity instanceof FamiliarEntity);
        ignore.add(arg_0 -> ((LivingEntity)shooter).m_7307_(arg_0));
        Set<IFilter> filters = GlyphEffectUtil.getFilters(spell.recipe, index);
        if (!filters.isEmpty()) {
            ignore.add(entity -> GlyphEffectUtil.checkIgnoreFilters(entity, filters));
        }
        return ignore;
    }
}

