/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.mermaid_block;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.entity.MermaidEntity;
import alexthw.ars_elemental.common.entity.spells.EntityLerpedProjectile;
import alexthw.ars_elemental.registry.ModTiles;
import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public class MermaidTile
extends SummoningTile
implements ITooltipProvider {
    public int progress;
    public int bonus;
    public boolean needsMana;
    public static final ParticleColor shrineParticle = new ParticleColor(20, 100, 200);

    public MermaidTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.MERMAID_TILE.get(), pos, state);
    }

    public void convertedEffect() {
        super.convertedEffect();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (this.tickCounter >= 120) {
                this.converted = true;
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(true)));
                MermaidEntity mermaid = new MermaidEntity(this.f_58857_, true);
                mermaid.m_6034_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5);
                mermaid.setHome(this.m_58899_());
                this.f_58857_.m_7967_((Entity)mermaid);
                ParticleUtil.spawnPoof((ServerLevel)world, (BlockPos)this.f_58858_.m_7494_());
                this.tickCounter = 0;
                return;
            }
            if (this.tickCounter % 10 == 0) {
                RandomSource r = this.f_58857_.f_46441_;
                int min = -2;
                int max = 2;
                EntityFollowProjectile proj1 = new EntityFollowProjectile(this.f_58857_, this.f_58858_.m_7918_(r.m_188503_(max - min) + min, 3, r.m_188503_(max - min) + min), this.f_58858_, r.m_188503_(255), r.m_188503_(255), r.m_188503_(255));
                this.f_58857_.m_7967_((Entity)proj1);
            }
        }
    }

    public int getMaxProgress() {
        return (Integer)ConfigHandler.Common.SIREN_MAX_PROGRESS.get();
    }

    public void giveProgress() {
        if (this.progress < this.getMaxProgress() && this.f_58857_ != null) {
            ++this.progress;
            this.updateBlock();
        }
    }

    public void evaluateAquarium() {
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        HashSet<BlockState> blocks = new HashSet<BlockState>();
        int score = 0;
        int water = 0;
        for (BlockPos b2 : BlockPos.m_121940_((BlockPos)this.m_58899_().m_122013_(8).m_122025_(8).m_6625_(10), (BlockPos)this.m_58899_().m_122020_(8).m_122030_(8).m_6630_(10))) {
            if (world.m_151570_(b2)) continue;
            BlockState block = world.m_8055_(b2);
            int points = this.getScore(block);
            switch (points) {
                case 0: 
                case 1: {
                    ++water;
                }
            }
            score += blocks.add(block) ? points : 0;
        }
        if (water > 50) {
            HashSet entities = new HashSet();
            score += this.getNearbyEntities().stream().filter(b -> entities.add(b.m_6095_())).mapToInt(b -> 5).sum();
        }
        this.bonus = score;
    }

    public int getScore(BlockState state) {
        if (state.m_60795_()) {
            return 0;
        }
        if (state == Blocks.f_49990_.m_49966_()) {
            return 1;
        }
        if (state.m_204336_(BlockTags.f_13064_) || state.m_60734_() instanceof KelpPlantBlock || state.m_60734_() instanceof CoralBlock) {
            return 2;
        }
        return 0;
    }

    ItemStack getRod() {
        return Items.f_42523_.m_7968_();
    }

    public void generateItems() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)server);
        LootDataManager lootData = server.m_7654_().m_278653_();
        LootTable lootTable = lootData.m_278676_(BuiltInLootTables.f_78723_);
        LootTable lootTableTreasure = lootData.m_278676_(BuiltInLootTables.f_78722_);
        LootTable lootTableJunk = lootData.m_278676_(BuiltInLootTables.f_78721_);
        LootParams lootContext = new LootParams.Builder(server).m_287286_(LootContextParams.f_81460_, (Object)fakePlayer.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)this.getRod()).m_287235_(LootContextParamSets.f_81414_);
        boolean flag = true;
        int bonus_rolls = Math.min(this.bonus / 25, (Integer)ConfigHandler.Common.SIREN_UNIQUE_BONUS.get());
        int counter = 0;
        for (int i = 0; i < (Integer)ConfigHandler.Common.SIREN_BASE_ITEM.get() + bonus_rolls; ++i) {
            ObjectArrayList list;
            if (flag && this.bonus > 30 && this.f_58857_.f_46441_.m_188500_() < 0.1 + (double)this.bonus * (Double)ConfigHandler.Common.SIREN_TREASURE_BONUS.get()) {
                list = lootTableTreasure.m_287195_(lootContext);
                flag = false;
            } else {
                list = flag && this.bonus <= 25 && this.f_58857_.f_46441_.m_188500_() < (double)0.2f ? lootTableJunk.m_287195_(lootContext) : lootTable.m_287195_(lootContext);
            }
            for (ItemStack item : list) {
                BlockUtil.insertItemAdjacent((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)item);
                ++counter;
            }
            if (counter >= (Integer)ConfigHandler.Common.SIREN_QUANTITY_CAP.get()) break;
        }
        this.progress = 0;
        this.needsMana = true;
        this.updateBlock();
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null || this.isOff) {
            return;
        }
        if (this.f_58857_.m_5776_() && !this.needsMana) {
            for (int i = 0; i < this.progress / 2; ++i) {
                this.f_58857_.m_7106_(GlowParticleData.createData((ParticleColor)shrineParticle, (float)((float)i / 2.0f * 0.2f), (float)((float)i / 2.0f * 0.75f), (int)20), (double)this.m_58899_().m_123341_() + 0.5 + ParticleUtil.inRange((double)-0.1, (double)0.1), (double)this.m_58899_().m_123342_() + 1.0 + ParticleUtil.inRange((double)-0.1, (double)0.1), (double)this.m_58899_().m_123343_() + 0.5 + ParticleUtil.inRange((double)-0.1, (double)0.1), 0.0, 0.0, 0.0);
            }
        } else {
            long gameTime = this.f_58857_.m_46467_();
            if (gameTime % 2400L == 0L) {
                this.evaluateAquarium();
            }
            if (gameTime % 80L == 0L && this.needsMana && SourceUtil.takeSourceWithParticles((BlockPos)this.f_58858_, (Level)this.f_58857_, (int)7, (int)((Integer)ConfigHandler.Common.SIREN_MANA_COST.get())) != null) {
                this.needsMana = false;
                this.updateBlock();
            }
            if (gameTime % 2000L == 0L && !this.needsMana) {
                if (this.progress >= this.getMaxProgress()) {
                    this.generateItems();
                } else {
                    LivingEntity rnd = this.getRandomEntity();
                    if (rnd != null) {
                        EntityLerpedProjectile orb = new EntityLerpedProjectile(this.f_58857_, rnd.m_20183_(), this.m_58899_(), 20, 50, 255);
                        this.f_58857_.m_7967_((Entity)orb);
                        this.giveProgress();
                    }
                }
            }
        }
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.needsMana) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.wixie.need_mana"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)("Aquarium Bonus: " + this.bonus)));
        }
    }

    public void m_142466_(CompoundTag compound) {
        this.progress = compound.m_128451_("progress");
        this.bonus = compound.m_128451_("bonus");
        this.needsMana = compound.m_128471_("needsMana");
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("bonus", this.bonus);
        tag.m_128379_("needsMana", this.needsMana);
    }

    public LivingEntity getRandomEntity() {
        if (this.getNearbyEntities().isEmpty() || this.f_58857_ == null) {
            return null;
        }
        return this.getNearbyEntities().get(this.f_58857_.f_46441_.m_188503_(this.getNearbyEntities().size()));
    }

    private List<LivingEntity> getNearbyEntities() {
        if (this.f_58857_ == null) {
            return ImmutableList.of();
        }
        return this.f_58857_.m_6443_(LivingEntity.class, new AABB(this.m_58899_().m_122013_(10).m_122025_(10).m_6625_(10), this.m_58899_().m_122020_(10).m_122030_(10).m_6630_(10)), e -> e.m_6336_() == MobType.f_21644_ && !(e instanceof MermaidEntity));
    }
}

